/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class Token {
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="customerEmailAddress")
    protected String customerEmailAddress = null;
    @JsonProperty(value="customerId")
    protected String customerId = null;
    @JsonProperty(value="enabledForOneClickPayment")
    protected Boolean enabledForOneClickPayment = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="tokenReference")
    protected String tokenReference = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The date and time when the object was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The customer's email address.")
    public String getCustomerEmailAddress() {
        return this.customerEmailAddress;
    }

    @ApiModelProperty(value="The unique identifier of the customer in the external system.")
    public String getCustomerId() {
        return this.customerId;
    }

    @ApiModelProperty(value="Whether the token is enabled for one-click payments, which simplify the payment process for the customer. One-click tokens are linked to customers via the customer ID.")
    public Boolean isEnabledForOneClickPayment() {
        return this.enabledForOneClickPayment;
    }

    @ApiModelProperty(value="A client generated nonce which identifies the entity to be created. Subsequent creation requests with the same external ID will not create new entities but return the initially created entity instead.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The customer's time zone, which affects how dates and times are formatted when communicating with the customer.")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="The reference used to identify the payment token (e.g. the customer's ID or email address).")
    public String getTokenReference() {
        return this.tokenReference;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.createdOn, token.createdOn) && Objects.equals(this.customerEmailAddress, token.customerEmailAddress) && Objects.equals(this.customerId, token.customerId) && Objects.equals(this.enabledForOneClickPayment, token.enabledForOneClickPayment) && Objects.equals(this.externalId, token.externalId) && Objects.equals(this.id, token.id) && Objects.equals(this.language, token.language) && Objects.equals(this.linkedSpaceId, token.linkedSpaceId) && Objects.equals(this.plannedPurgeDate, token.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)token.state) && Objects.equals(this.timeZone, token.timeZone) && Objects.equals(this.tokenReference, token.tokenReference) && Objects.equals(this.version, token.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdOn, this.customerEmailAddress, this.customerId, this.enabledForOneClickPayment, this.externalId, this.id, this.language, this.linkedSpaceId, this.plannedPurgeDate, this.state, this.timeZone, this.tokenReference, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Token {\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    customerEmailAddress: ").append(this.toIndentedString(this.customerEmailAddress)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    enabledForOneClickPayment: ").append(this.toIndentedString(this.enabledForOneClickPayment)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    tokenReference: ").append(this.toIndentedString(this.tokenReference)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

