/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.TerminalReceiptFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The receipt fetch request allows to retrieve the receipt documents for a terminal transaction.")
public class TerminalReceiptFetchRequest {
    @JsonProperty(value="format")
    protected TerminalReceiptFormat format = null;
    @JsonProperty(value="transaction")
    protected Long transaction = null;
    @JsonProperty(value="width")
    protected Integer width = null;

    public TerminalReceiptFetchRequest format(TerminalReceiptFormat format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(required=true, value="The format determines in what format the receipts will be returned in.")
    public TerminalReceiptFormat getFormat() {
        return this.format;
    }

    public void setFormat(TerminalReceiptFormat format) {
        this.format = format;
    }

    public TerminalReceiptFetchRequest transaction(Long transaction) {
        this.transaction = transaction;
        return this;
    }

    @ApiModelProperty(required=true, value="Provide here the ID of the transaction for which the receipts should be fetched.")
    public Long getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Long transaction) {
        this.transaction = transaction;
    }

    public TerminalReceiptFetchRequest width(Integer width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(value="The width controls how width the document will be rendered. In case of the PDF format the width is in mm. In case of the text format the width is in the number of chars per line.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalReceiptFetchRequest terminalReceiptFetchRequest = (TerminalReceiptFetchRequest)o;
        return Objects.equals((Object)this.format, (Object)terminalReceiptFetchRequest.format) && Objects.equals(this.transaction, terminalReceiptFetchRequest.transaction) && Objects.equals(this.width, terminalReceiptFetchRequest.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.transaction, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalReceiptFetchRequest {\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    transaction: ").append(this.toIndentedString(this.transaction)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

