/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.PaymentMethodConfiguration;
import ch.postfinance.sdk.model.ShopifyAdditionalLineItemData;
import ch.postfinance.sdk.model.ShopifyIntegrationPaymentAppVersion;
import ch.postfinance.sdk.model.ShopifyIntegrationSubscriptionAppVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A Shopify Integration allows to connect a Shopify shop.")
public class ShopifyV1Integration {
    @JsonProperty(value="additionalLineItemData")
    protected List<ShopifyAdditionalLineItemData> additionalLineItemData = null;
    @JsonProperty(value="allowInvoiceDownload")
    protected Boolean allowInvoiceDownload = null;
    @JsonProperty(value="allowedPaymentMethodConfigurations")
    protected List<PaymentMethodConfiguration> allowedPaymentMethodConfigurations = null;
    @JsonProperty(value="currency")
    protected String currency = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="integratedPaymentFormEnabled")
    protected Boolean integratedPaymentFormEnabled = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="loginName")
    protected String loginName = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="paymentAppVersion")
    protected ShopifyIntegrationPaymentAppVersion paymentAppVersion = null;
    @JsonProperty(value="paymentInstalled")
    protected Boolean paymentInstalled = null;
    @JsonProperty(value="paymentProxyPath")
    protected String paymentProxyPath = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="replacePaymentMethodImage")
    protected Boolean replacePaymentMethodImage = null;
    @JsonProperty(value="shopName")
    protected String shopName = null;
    @JsonProperty(value="showPaymentInformation")
    protected Boolean showPaymentInformation = null;
    @JsonProperty(value="showSubscriptionInformation")
    protected Boolean showSubscriptionInformation = null;
    @JsonProperty(value="spaceId")
    protected Long spaceId = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="subscriptionAppVersion")
    protected ShopifyIntegrationSubscriptionAppVersion subscriptionAppVersion = null;
    @JsonProperty(value="subscriptionInstalled")
    protected Boolean subscriptionInstalled = null;
    @JsonProperty(value="subscriptionProxyPath")
    protected String subscriptionProxyPath = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="")
    public List<ShopifyAdditionalLineItemData> getAdditionalLineItemData() {
        return this.additionalLineItemData;
    }

    @ApiModelProperty(value="")
    public Boolean isAllowInvoiceDownload() {
        return this.allowInvoiceDownload;
    }

    @ApiModelProperty(value="")
    public List<PaymentMethodConfiguration> getAllowedPaymentMethodConfigurations() {
        return this.allowedPaymentMethodConfigurations;
    }

    @ApiModelProperty(value="")
    public String getCurrency() {
        return this.currency;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="Enabling the integrated payment form will embed the payment form in the Shopify shop. The app needs to be installed for this to be possible.")
    public Boolean isIntegratedPaymentFormEnabled() {
        return this.integratedPaymentFormEnabled;
    }

    @ApiModelProperty(value="The checkout language forces a specific language in the checkout. Without a checkout language the browser setting of the buyer is used to determine the language.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The login name is used to link a specific Shopify payment gateway to this integration.This login name is to be filled into the appropriate field in the shop's payment gateway configuration.")
    public String getLoginName() {
        return this.loginName;
    }

    @ApiModelProperty(value="The integration name is used internally to identify a specific integration.For example the name is used withinsearch fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="")
    public ShopifyIntegrationPaymentAppVersion getPaymentAppVersion() {
        return this.paymentAppVersion;
    }

    @ApiModelProperty(value="")
    public Boolean isPaymentInstalled() {
        return this.paymentInstalled;
    }

    @ApiModelProperty(value="Define the path of the proxy URL. This only needs to be changed if the app's proxy URL is overwritten in the Shopify store.")
    public String getPaymentProxyPath() {
        return this.paymentProxyPath;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public Boolean isReplacePaymentMethodImage() {
        return this.replacePaymentMethodImage;
    }

    @ApiModelProperty(value="The store address is used to link a specific Shopify shop to this integration. This is the name used in the Shopify's admin URL: [storeAddress].myshopify.com")
    public String getShopName() {
        return this.shopName;
    }

    @ApiModelProperty(value="")
    public Boolean isShowPaymentInformation() {
        return this.showPaymentInformation;
    }

    @ApiModelProperty(value="")
    public Boolean isShowSubscriptionInformation() {
        return this.showSubscriptionInformation;
    }

    @ApiModelProperty(value="")
    public Long getSpaceId() {
        return this.spaceId;
    }

    @ApiModelProperty(value="The ID of the space view this object is linked to.")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public ShopifyIntegrationSubscriptionAppVersion getSubscriptionAppVersion() {
        return this.subscriptionAppVersion;
    }

    @ApiModelProperty(value="")
    public Boolean isSubscriptionInstalled() {
        return this.subscriptionInstalled;
    }

    @ApiModelProperty(value="Define the path of the proxy URL. This only needs to be changed if the app's proxy URL is overwritten in the Shopify store.")
    public String getSubscriptionProxyPath() {
        return this.subscriptionProxyPath;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopifyV1Integration shopifyV1Integration = (ShopifyV1Integration)o;
        return Objects.equals(this.additionalLineItemData, shopifyV1Integration.additionalLineItemData) && Objects.equals(this.allowInvoiceDownload, shopifyV1Integration.allowInvoiceDownload) && Objects.equals(this.allowedPaymentMethodConfigurations, shopifyV1Integration.allowedPaymentMethodConfigurations) && Objects.equals(this.currency, shopifyV1Integration.currency) && Objects.equals(this.id, shopifyV1Integration.id) && Objects.equals(this.integratedPaymentFormEnabled, shopifyV1Integration.integratedPaymentFormEnabled) && Objects.equals(this.language, shopifyV1Integration.language) && Objects.equals(this.loginName, shopifyV1Integration.loginName) && Objects.equals(this.name, shopifyV1Integration.name) && Objects.equals((Object)this.paymentAppVersion, (Object)shopifyV1Integration.paymentAppVersion) && Objects.equals(this.paymentInstalled, shopifyV1Integration.paymentInstalled) && Objects.equals(this.paymentProxyPath, shopifyV1Integration.paymentProxyPath) && Objects.equals(this.plannedPurgeDate, shopifyV1Integration.plannedPurgeDate) && Objects.equals(this.replacePaymentMethodImage, shopifyV1Integration.replacePaymentMethodImage) && Objects.equals(this.shopName, shopifyV1Integration.shopName) && Objects.equals(this.showPaymentInformation, shopifyV1Integration.showPaymentInformation) && Objects.equals(this.showSubscriptionInformation, shopifyV1Integration.showSubscriptionInformation) && Objects.equals(this.spaceId, shopifyV1Integration.spaceId) && Objects.equals(this.spaceViewId, shopifyV1Integration.spaceViewId) && Objects.equals((Object)this.state, (Object)shopifyV1Integration.state) && Objects.equals((Object)this.subscriptionAppVersion, (Object)shopifyV1Integration.subscriptionAppVersion) && Objects.equals(this.subscriptionInstalled, shopifyV1Integration.subscriptionInstalled) && Objects.equals(this.subscriptionProxyPath, shopifyV1Integration.subscriptionProxyPath) && Objects.equals(this.version, shopifyV1Integration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalLineItemData, this.allowInvoiceDownload, this.allowedPaymentMethodConfigurations, this.currency, this.id, this.integratedPaymentFormEnabled, this.language, this.loginName, this.name, this.paymentAppVersion, this.paymentInstalled, this.paymentProxyPath, this.plannedPurgeDate, this.replacePaymentMethodImage, this.shopName, this.showPaymentInformation, this.showSubscriptionInformation, this.spaceId, this.spaceViewId, this.state, this.subscriptionAppVersion, this.subscriptionInstalled, this.subscriptionProxyPath, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShopifyV1Integration {\n");
        sb.append("    additionalLineItemData: ").append(this.toIndentedString(this.additionalLineItemData)).append("\n");
        sb.append("    allowInvoiceDownload: ").append(this.toIndentedString(this.allowInvoiceDownload)).append("\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    integratedPaymentFormEnabled: ").append(this.toIndentedString(this.integratedPaymentFormEnabled)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    loginName: ").append(this.toIndentedString(this.loginName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    paymentAppVersion: ").append(this.toIndentedString((Object)this.paymentAppVersion)).append("\n");
        sb.append("    paymentInstalled: ").append(this.toIndentedString(this.paymentInstalled)).append("\n");
        sb.append("    paymentProxyPath: ").append(this.toIndentedString(this.paymentProxyPath)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    replacePaymentMethodImage: ").append(this.toIndentedString(this.replacePaymentMethodImage)).append("\n");
        sb.append("    shopName: ").append(this.toIndentedString(this.shopName)).append("\n");
        sb.append("    showPaymentInformation: ").append(this.toIndentedString(this.showPaymentInformation)).append("\n");
        sb.append("    showSubscriptionInformation: ").append(this.toIndentedString(this.showSubscriptionInformation)).append("\n");
        sb.append("    spaceId: ").append(this.toIndentedString(this.spaceId)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    subscriptionAppVersion: ").append(this.toIndentedString((Object)this.subscriptionAppVersion)).append("\n");
        sb.append("    subscriptionInstalled: ").append(this.toIndentedString(this.subscriptionInstalled)).append("\n");
        sb.append("    subscriptionProxyPath: ").append(this.toIndentedString(this.subscriptionProxyPath)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

