/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.Feature;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class Scope {
    @JsonProperty(value="domainName")
    protected String domainName = null;
    @JsonProperty(value="features")
    protected List<Feature> features = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="machineName")
    protected String machineName = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="port")
    protected Integer port = null;
    @JsonProperty(value="sslActive")
    protected Boolean sslActive = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="themes")
    protected List<String> themes = null;
    @JsonProperty(value="url")
    protected String url = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The domain name that belongs to the scope.")
    public String getDomainName() {
        return this.domainName;
    }

    @ApiModelProperty(value="The list of features that are active in the scope.")
    public List<Feature> getFeatures() {
        return this.features;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The name identifying the scope in e.g. URLs.")
    public String getMachineName() {
        return this.machineName;
    }

    @ApiModelProperty(value="The name used to identify the scope.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The port where the scope can be accessed.")
    public Integer getPort() {
        return this.port;
    }

    @ApiModelProperty(value="Whether the scope supports SSL.")
    public Boolean isSslActive() {
        return this.sslActive;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The themes that determine the look and feel of the scope's user interface. A fall-through strategy is applied when building the actual theme.")
    public List<String> getThemes() {
        return this.themes;
    }

    @ApiModelProperty(value="The URL where the scope can be accessed.")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scope scope = (Scope)o;
        return Objects.equals(this.domainName, scope.domainName) && Objects.equals(this.features, scope.features) && Objects.equals(this.id, scope.id) && Objects.equals(this.machineName, scope.machineName) && Objects.equals(this.name, scope.name) && Objects.equals(this.plannedPurgeDate, scope.plannedPurgeDate) && Objects.equals(this.port, scope.port) && Objects.equals(this.sslActive, scope.sslActive) && Objects.equals((Object)this.state, (Object)scope.state) && Objects.equals(this.themes, scope.themes) && Objects.equals(this.url, scope.url) && Objects.equals(this.version, scope.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domainName, this.features, this.id, this.machineName, this.name, this.plannedPurgeDate, this.port, this.sslActive, this.state, this.themes, this.url, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Scope {\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    machineName: ").append(this.toIndentedString(this.machineName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    sslActive: ").append(this.toIndentedString(this.sslActive)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    themes: ").append(this.toIndentedString(this.themes)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

