/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="")
public class RestLanguage {
    @JsonProperty(value="countryCode")
    protected String countryCode = null;
    @JsonProperty(value="ietfCode")
    protected String ietfCode = null;
    @JsonProperty(value="iso2Code")
    protected String iso2Code = null;
    @JsonProperty(value="iso3Code")
    protected String iso3Code = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="pluralExpression")
    protected String pluralExpression = null;
    @JsonProperty(value="primaryOfGroup")
    protected Boolean primaryOfGroup = null;

    @ApiModelProperty(value="The two-letter code of the language's region (ISO 3166-1 alpha-2 format).")
    public String getCountryCode() {
        return this.countryCode;
    }

    @ApiModelProperty(value="The language's IETF tag consisting of the two-letter ISO code and region e.g. en-US, de-CH.")
    public String getIetfCode() {
        return this.ietfCode;
    }

    @ApiModelProperty(value="The language's two-letter code (ISO 639-1 format).")
    public String getIso2Code() {
        return this.iso2Code;
    }

    @ApiModelProperty(value="The language's three-letter code (ISO 639-2/T format).")
    public String getIso3Code() {
        return this.iso3Code;
    }

    @ApiModelProperty(value="The name of the language.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The expression to determine the plural index for a given number of items used to find the proper plural form for translations.")
    public String getPluralExpression() {
        return this.pluralExpression;
    }

    @ApiModelProperty(value="Whether this is the primary language in a group of languages.")
    public Boolean isPrimaryOfGroup() {
        return this.primaryOfGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestLanguage restLanguage = (RestLanguage)o;
        return Objects.equals(this.countryCode, restLanguage.countryCode) && Objects.equals(this.ietfCode, restLanguage.ietfCode) && Objects.equals(this.iso2Code, restLanguage.iso2Code) && Objects.equals(this.iso3Code, restLanguage.iso3Code) && Objects.equals(this.name, restLanguage.name) && Objects.equals(this.pluralExpression, restLanguage.pluralExpression) && Objects.equals(this.primaryOfGroup, restLanguage.primaryOfGroup);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.ietfCode, this.iso2Code, this.iso3Code, this.name, this.pluralExpression, this.primaryOfGroup);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestLanguage {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    ietfCode: ").append(this.toIndentedString(this.ietfCode)).append("\n");
        sb.append("    iso2Code: ").append(this.toIndentedString(this.iso2Code)).append("\n");
        sb.append("    iso3Code: ").append(this.toIndentedString(this.iso3Code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pluralExpression: ").append(this.toIndentedString(this.pluralExpression)).append("\n");
        sb.append("    primaryOfGroup: ").append(this.toIndentedString(this.primaryOfGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

