/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.BankTransaction;
import ch.postfinance.sdk.model.LineItem;
import ch.postfinance.sdk.model.Refund;
import ch.postfinance.sdk.model.TransactionAwareEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class RefundRecoveryBankTransaction
extends TransactionAwareEntity {
    @JsonProperty(value="bankTransaction")
    protected BankTransaction bankTransaction = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItem> lineItems = null;
    @JsonProperty(value="refund")
    protected Refund refund = null;
    @JsonProperty(value="refundCurrencyAmount")
    protected BigDecimal refundCurrencyAmount = null;
    @JsonProperty(value="refundCurrencyValueAmount")
    protected BigDecimal refundCurrencyValueAmount = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="")
    public BankTransaction getBankTransaction() {
        return this.bankTransaction;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The line items contain the items which could be recovered.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @ApiModelProperty(value="")
    public Refund getRefund() {
        return this.refund;
    }

    @ApiModelProperty(value="Specify the posting amount in the refund's currency.")
    public BigDecimal getRefundCurrencyAmount() {
        return this.refundCurrencyAmount;
    }

    @ApiModelProperty(value="")
    public BigDecimal getRefundCurrencyValueAmount() {
        return this.refundCurrencyValueAmount;
    }

    @ApiModelProperty(value="The ID of the space view this object is linked to.")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundRecoveryBankTransaction refundRecoveryBankTransaction = (RefundRecoveryBankTransaction)o;
        return Objects.equals(this.id, refundRecoveryBankTransaction.id) && Objects.equals(this.linkedSpaceId, refundRecoveryBankTransaction.linkedSpaceId) && Objects.equals(this.linkedTransaction, refundRecoveryBankTransaction.linkedTransaction) && Objects.equals(this.bankTransaction, refundRecoveryBankTransaction.bankTransaction) && Objects.equals(this.language, refundRecoveryBankTransaction.language) && Objects.equals(this.lineItems, refundRecoveryBankTransaction.lineItems) && Objects.equals(this.refund, refundRecoveryBankTransaction.refund) && Objects.equals(this.refundCurrencyAmount, refundRecoveryBankTransaction.refundCurrencyAmount) && Objects.equals(this.refundCurrencyValueAmount, refundRecoveryBankTransaction.refundCurrencyValueAmount) && Objects.equals(this.spaceViewId, refundRecoveryBankTransaction.spaceViewId) && Objects.equals(this.version, refundRecoveryBankTransaction.version) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.linkedSpaceId, this.linkedTransaction, this.bankTransaction, this.language, this.lineItems, this.refund, this.refundCurrencyAmount, this.refundCurrencyValueAmount, this.spaceViewId, this.version, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundRecoveryBankTransaction {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    linkedTransaction: ").append(this.toIndentedString(this.linkedTransaction)).append("\n");
        sb.append("    bankTransaction: ").append(this.toIndentedString(this.bankTransaction)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    refund: ").append(this.toIndentedString(this.refund)).append("\n");
        sb.append("    refundCurrencyAmount: ").append(this.toIndentedString(this.refundCurrencyAmount)).append("\n");
        sb.append("    refundCurrencyValueAmount: ").append(this.toIndentedString(this.refundCurrencyValueAmount)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

