/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Environment;
import ch.postfinance.sdk.model.FailureReason;
import ch.postfinance.sdk.model.Label;
import ch.postfinance.sdk.model.LineItem;
import ch.postfinance.sdk.model.LineItemReduction;
import ch.postfinance.sdk.model.RefundState;
import ch.postfinance.sdk.model.RefundType;
import ch.postfinance.sdk.model.Tax;
import ch.postfinance.sdk.model.Transaction;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The refund represents a credit back to the customer. It can be issued by the merchant or by the customer (reversal).")
public class Refund {
    @JsonProperty(value="amount")
    protected BigDecimal amount = null;
    @JsonProperty(value="baseLineItems")
    protected List<LineItem> baseLineItems = null;
    @JsonProperty(value="completion")
    protected Long completion = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="environment")
    protected Environment environment = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="failedOn")
    protected OffsetDateTime failedOn = null;
    @JsonProperty(value="failureReason")
    protected FailureReason failureReason = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="labels")
    protected List<Label> labels = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItem> lineItems = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="merchantReference")
    protected String merchantReference = null;
    @JsonProperty(value="nextUpdateOn")
    protected OffsetDateTime nextUpdateOn = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="processingOn")
    protected OffsetDateTime processingOn = null;
    @JsonProperty(value="processorReference")
    protected String processorReference = null;
    @JsonProperty(value="reducedLineItems")
    protected List<LineItem> reducedLineItems = null;
    @JsonProperty(value="reductions")
    protected List<LineItemReduction> reductions = null;
    @JsonProperty(value="state")
    protected RefundState state = null;
    @JsonProperty(value="succeededOn")
    protected OffsetDateTime succeededOn = null;
    @JsonProperty(value="taxes")
    protected List<Tax> taxes = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="timeoutOn")
    protected OffsetDateTime timeoutOn = null;
    @JsonProperty(value="totalAppliedFees")
    protected BigDecimal totalAppliedFees = null;
    @JsonProperty(value="totalSettledAmount")
    protected BigDecimal totalSettledAmount = null;
    @JsonProperty(value="transaction")
    protected Transaction transaction = null;
    @JsonProperty(value="type")
    protected RefundType type = null;
    @JsonProperty(value="updatedInvoice")
    protected Long updatedInvoice = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getBaseLineItems() {
        return this.baseLineItems;
    }

    @ApiModelProperty(value="")
    public Long getCompletion() {
        return this.completion;
    }

    @ApiModelProperty(value="")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The date and time when the object was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="")
    public Environment getEnvironment() {
        return this.environment;
    }

    @ApiModelProperty(value="The external id helps to identify duplicate calls to the refund service. As such the external ID has to be unique per transaction.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFailedOn() {
        return this.failedOn;
    }

    @ApiModelProperty(value="")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The labels providing additional information about the object.")
    public List<Label> getLabels() {
        return this.labels;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getNextUpdateOn() {
        return this.nextUpdateOn;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getProcessingOn() {
        return this.processingOn;
    }

    @ApiModelProperty(value="")
    public String getProcessorReference() {
        return this.processorReference;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getReducedLineItems() {
        return this.reducedLineItems;
    }

    @ApiModelProperty(value="")
    public List<LineItemReduction> getReductions() {
        return this.reductions;
    }

    @ApiModelProperty(value="The object's current state.")
    public RefundState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getSucceededOn() {
        return this.succeededOn;
    }

    @ApiModelProperty(value="")
    public List<Tax> getTaxes() {
        return this.taxes;
    }

    @ApiModelProperty(value="")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getTimeoutOn() {
        return this.timeoutOn;
    }

    @ApiModelProperty(value="The total applied fees is the sum of all fees that have been applied so far.")
    public BigDecimal getTotalAppliedFees() {
        return this.totalAppliedFees;
    }

    @ApiModelProperty(value="The total settled amount is the total amount which has been settled so far.")
    public BigDecimal getTotalSettledAmount() {
        return this.totalSettledAmount;
    }

    @ApiModelProperty(value="")
    public Transaction getTransaction() {
        return this.transaction;
    }

    @ApiModelProperty(value="")
    public RefundType getType() {
        return this.type;
    }

    @ApiModelProperty(value="")
    public Long getUpdatedInvoice() {
        return this.updatedInvoice;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Refund refund = (Refund)o;
        return Objects.equals(this.amount, refund.amount) && Objects.equals(this.baseLineItems, refund.baseLineItems) && Objects.equals(this.completion, refund.completion) && Objects.equals(this.createdBy, refund.createdBy) && Objects.equals(this.createdOn, refund.createdOn) && Objects.equals((Object)this.environment, (Object)refund.environment) && Objects.equals(this.externalId, refund.externalId) && Objects.equals(this.failedOn, refund.failedOn) && Objects.equals(this.failureReason, refund.failureReason) && Objects.equals(this.id, refund.id) && Objects.equals(this.labels, refund.labels) && Objects.equals(this.language, refund.language) && Objects.equals(this.lineItems, refund.lineItems) && Objects.equals(this.linkedSpaceId, refund.linkedSpaceId) && Objects.equals(this.merchantReference, refund.merchantReference) && Objects.equals(this.nextUpdateOn, refund.nextUpdateOn) && Objects.equals(this.plannedPurgeDate, refund.plannedPurgeDate) && Objects.equals(this.processingOn, refund.processingOn) && Objects.equals(this.processorReference, refund.processorReference) && Objects.equals(this.reducedLineItems, refund.reducedLineItems) && Objects.equals(this.reductions, refund.reductions) && Objects.equals((Object)this.state, (Object)refund.state) && Objects.equals(this.succeededOn, refund.succeededOn) && Objects.equals(this.taxes, refund.taxes) && Objects.equals(this.timeZone, refund.timeZone) && Objects.equals(this.timeoutOn, refund.timeoutOn) && Objects.equals(this.totalAppliedFees, refund.totalAppliedFees) && Objects.equals(this.totalSettledAmount, refund.totalSettledAmount) && Objects.equals(this.transaction, refund.transaction) && Objects.equals((Object)this.type, (Object)refund.type) && Objects.equals(this.updatedInvoice, refund.updatedInvoice) && Objects.equals(this.version, refund.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.baseLineItems, this.completion, this.createdBy, this.createdOn, this.environment, this.externalId, this.failedOn, this.failureReason, this.id, this.labels, this.language, this.lineItems, this.linkedSpaceId, this.merchantReference, this.nextUpdateOn, this.plannedPurgeDate, this.processingOn, this.processorReference, this.reducedLineItems, this.reductions, this.state, this.succeededOn, this.taxes, this.timeZone, this.timeoutOn, this.totalAppliedFees, this.totalSettledAmount, this.transaction, this.type, this.updatedInvoice, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Refund {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    baseLineItems: ").append(this.toIndentedString(this.baseLineItems)).append("\n");
        sb.append("    completion: ").append(this.toIndentedString(this.completion)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    failedOn: ").append(this.toIndentedString(this.failedOn)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    nextUpdateOn: ").append(this.toIndentedString(this.nextUpdateOn)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    processingOn: ").append(this.toIndentedString(this.processingOn)).append("\n");
        sb.append("    processorReference: ").append(this.toIndentedString(this.processorReference)).append("\n");
        sb.append("    reducedLineItems: ").append(this.toIndentedString(this.reducedLineItems)).append("\n");
        sb.append("    reductions: ").append(this.toIndentedString(this.reductions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    succeededOn: ").append(this.toIndentedString(this.succeededOn)).append("\n");
        sb.append("    taxes: ").append(this.toIndentedString(this.taxes)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    timeoutOn: ").append(this.toIndentedString(this.timeoutOn)).append("\n");
        sb.append("    totalAppliedFees: ").append(this.toIndentedString(this.totalAppliedFees)).append("\n");
        sb.append("    totalSettledAmount: ").append(this.toIndentedString(this.totalSettledAmount)).append("\n");
        sb.append("    transaction: ").append(this.toIndentedString(this.transaction)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updatedInvoice: ").append(this.toIndentedString(this.updatedInvoice)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

