/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.PaymentTerminalAddress;
import ch.postfinance.sdk.model.PaymentTerminalLocation;
import ch.postfinance.sdk.model.PaymentTerminalLocationVersionState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class PaymentTerminalLocationVersion {
    @JsonProperty(value="address")
    protected PaymentTerminalAddress address = null;
    @JsonProperty(value="contactAddress")
    protected PaymentTerminalAddress contactAddress = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="location")
    protected PaymentTerminalLocation location = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected PaymentTerminalLocationVersionState state = null;
    @JsonProperty(value="version")
    protected Integer version = null;
    @JsonProperty(value="versionAppliedImmediately")
    protected Boolean versionAppliedImmediately = null;

    @ApiModelProperty(value="The postal address of the location where the payment terminals are used.")
    public PaymentTerminalAddress getAddress() {
        return this.address;
    }

    @ApiModelProperty(value="The contact details if the person responsible for the payment terminals at this location.")
    public PaymentTerminalAddress getContactAddress() {
        return this.contactAddress;
    }

    @ApiModelProperty(value="The ID of the user the payment terminal location version was created by.")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The date and time when the object was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The payment terminal location that the version belongs to.")
    public PaymentTerminalLocation getLocation() {
        return this.location;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public PaymentTerminalLocationVersionState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(value="Whether payment terminals are immediately updated to this configuration version. If not, it will be applied during the maintenance window.")
    public Boolean isVersionAppliedImmediately() {
        return this.versionAppliedImmediately;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTerminalLocationVersion paymentTerminalLocationVersion = (PaymentTerminalLocationVersion)o;
        return Objects.equals(this.address, paymentTerminalLocationVersion.address) && Objects.equals(this.contactAddress, paymentTerminalLocationVersion.contactAddress) && Objects.equals(this.createdBy, paymentTerminalLocationVersion.createdBy) && Objects.equals(this.createdOn, paymentTerminalLocationVersion.createdOn) && Objects.equals(this.id, paymentTerminalLocationVersion.id) && Objects.equals(this.linkedSpaceId, paymentTerminalLocationVersion.linkedSpaceId) && Objects.equals(this.location, paymentTerminalLocationVersion.location) && Objects.equals(this.plannedPurgeDate, paymentTerminalLocationVersion.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)paymentTerminalLocationVersion.state) && Objects.equals(this.version, paymentTerminalLocationVersion.version) && Objects.equals(this.versionAppliedImmediately, paymentTerminalLocationVersion.versionAppliedImmediately);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.contactAddress, this.createdBy, this.createdOn, this.id, this.linkedSpaceId, this.location, this.plannedPurgeDate, this.state, this.version, this.versionAppliedImmediately});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentTerminalLocationVersion {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    contactAddress: ").append(this.toIndentedString(this.contactAddress)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionAppliedImmediately: ").append(this.toIndentedString(this.versionAppliedImmediately)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

