/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.PaymentTerminalConfigurationVersion;
import ch.postfinance.sdk.model.PaymentTerminalLocationVersion;
import ch.postfinance.sdk.model.PaymentTerminalState;
import ch.postfinance.sdk.model.PaymentTerminalType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class PaymentTerminal {
    @JsonProperty(value="configurationVersion")
    protected PaymentTerminalConfigurationVersion configurationVersion = null;
    @JsonProperty(value="defaultCurrency")
    protected String defaultCurrency = null;
    @JsonProperty(value="deviceName")
    protected String deviceName = null;
    @JsonProperty(value="deviceSerialNumber")
    protected String deviceSerialNumber = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="identifier")
    protected String identifier = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="locationVersion")
    protected PaymentTerminalLocationVersion locationVersion = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected PaymentTerminalState state = null;
    @JsonProperty(value="type")
    protected PaymentTerminalType type = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The configuration that is assigned to the terminal and determines how it works.")
    public PaymentTerminalConfigurationVersion getConfigurationVersion() {
        return this.configurationVersion;
    }

    @ApiModelProperty(value="The default currency of the terminal.")
    public String getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @ApiModelProperty(value="The name of the device that is currently linked to the payment terminal.")
    public String getDeviceName() {
        return this.deviceName;
    }

    @ApiModelProperty(value="The serial number of the device that is currently linked to the payment terminal.")
    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    @ApiModelProperty(value="A client generated nonce which identifies the entity to be created. Subsequent creation requests with the same external ID will not create new entities but return the initially created entity instead.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The unique identifier of the terminal, that is displayed on the device.")
    public String getIdentifier() {
        return this.identifier;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The physical location where the terminal is used.")
    public PaymentTerminalLocationVersion getLocationVersion() {
        return this.locationVersion;
    }

    @ApiModelProperty(value="The name used to identify the payment terminal.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public PaymentTerminalState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The type of the payment terminal.")
    public PaymentTerminalType getType() {
        return this.type;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTerminal paymentTerminal = (PaymentTerminal)o;
        return Objects.equals(this.configurationVersion, paymentTerminal.configurationVersion) && Objects.equals(this.defaultCurrency, paymentTerminal.defaultCurrency) && Objects.equals(this.deviceName, paymentTerminal.deviceName) && Objects.equals(this.deviceSerialNumber, paymentTerminal.deviceSerialNumber) && Objects.equals(this.externalId, paymentTerminal.externalId) && Objects.equals(this.id, paymentTerminal.id) && Objects.equals(this.identifier, paymentTerminal.identifier) && Objects.equals(this.linkedSpaceId, paymentTerminal.linkedSpaceId) && Objects.equals(this.locationVersion, paymentTerminal.locationVersion) && Objects.equals(this.name, paymentTerminal.name) && Objects.equals(this.plannedPurgeDate, paymentTerminal.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)paymentTerminal.state) && Objects.equals(this.type, paymentTerminal.type) && Objects.equals(this.version, paymentTerminal.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configurationVersion, this.defaultCurrency, this.deviceName, this.deviceSerialNumber, this.externalId, this.id, this.identifier, this.linkedSpaceId, this.locationVersion, this.name, this.plannedPurgeDate, this.state, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentTerminal {\n");
        sb.append("    configurationVersion: ").append(this.toIndentedString(this.configurationVersion)).append("\n");
        sb.append("    defaultCurrency: ").append(this.toIndentedString(this.defaultCurrency)).append("\n");
        sb.append("    deviceName: ").append(this.toIndentedString(this.deviceName)).append("\n");
        sb.append("    deviceSerialNumber: ").append(this.toIndentedString(this.deviceSerialNumber)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    locationVersion: ").append(this.toIndentedString(this.locationVersion)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

