/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class PaymentProcessorConfiguration {
    @JsonProperty(value="applicationManaged")
    protected Boolean applicationManaged = null;
    @JsonProperty(value="contractId")
    protected Long contractId = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="processor")
    protected Long processor = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="Whether the processor configuration is managed by the application and therefore cannot be changed.")
    public Boolean isApplicationManaged() {
        return this.applicationManaged;
    }

    @ApiModelProperty(value="The ID of the payment contract the processor configuration is linked to.")
    public Long getContractId() {
        return this.contractId;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The name used to identify the payment method configuration.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The payment processor that the configuration is for.")
    public Long getProcessor() {
        return this.processor;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentProcessorConfiguration paymentProcessorConfiguration = (PaymentProcessorConfiguration)o;
        return Objects.equals(this.applicationManaged, paymentProcessorConfiguration.applicationManaged) && Objects.equals(this.contractId, paymentProcessorConfiguration.contractId) && Objects.equals(this.id, paymentProcessorConfiguration.id) && Objects.equals(this.linkedSpaceId, paymentProcessorConfiguration.linkedSpaceId) && Objects.equals(this.name, paymentProcessorConfiguration.name) && Objects.equals(this.plannedPurgeDate, paymentProcessorConfiguration.plannedPurgeDate) && Objects.equals(this.processor, paymentProcessorConfiguration.processor) && Objects.equals((Object)this.state, (Object)paymentProcessorConfiguration.state) && Objects.equals(this.version, paymentProcessorConfiguration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicationManaged, this.contractId, this.id, this.linkedSpaceId, this.name, this.plannedPurgeDate, this.processor, this.state, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentProcessorConfiguration {\n");
        sb.append("    applicationManaged: ").append(this.toIndentedString(this.applicationManaged)).append("\n");
        sb.append("    contractId: ").append(this.toIndentedString(this.contractId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    processor: ").append(this.toIndentedString(this.processor)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

