/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Payment processors handle the connection to third part companies (payment service providers) that technically manage payment transactions and therefore process payments.")
public class PaymentProcessor {
    @JsonProperty(value="companyName")
    protected Map<String, String> companyName = null;
    @JsonProperty(value="description")
    protected Map<String, String> description = null;
    @JsonProperty(value="headquartersLocation")
    protected Map<String, String> headquartersLocation = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="logoPath")
    protected String logoPath = null;
    @JsonProperty(value="name")
    protected Map<String, String> name = null;
    @JsonProperty(value="productName")
    protected Map<String, String> productName = null;

    @ApiModelProperty(value="The name of the company to which the processor belongs.")
    public Map<String, String> getCompanyName() {
        return this.companyName;
    }

    @ApiModelProperty(value="The localized description of the object.")
    public Map<String, String> getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="Where the processor's headquarters are located.")
    public Map<String, String> getHeadquartersLocation() {
        return this.headquartersLocation;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The path to the logo image of the processor.")
    public String getLogoPath() {
        return this.logoPath;
    }

    @ApiModelProperty(value="The localized name of the object.")
    public Map<String, String> getName() {
        return this.name;
    }

    @ApiModelProperty(value="The name of the processor's product.")
    public Map<String, String> getProductName() {
        return this.productName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentProcessor paymentProcessor = (PaymentProcessor)o;
        return Objects.equals(this.companyName, paymentProcessor.companyName) && Objects.equals(this.description, paymentProcessor.description) && Objects.equals(this.headquartersLocation, paymentProcessor.headquartersLocation) && Objects.equals(this.id, paymentProcessor.id) && Objects.equals(this.logoPath, paymentProcessor.logoPath) && Objects.equals(this.name, paymentProcessor.name) && Objects.equals(this.productName, paymentProcessor.productName);
    }

    public int hashCode() {
        return Objects.hash(this.companyName, this.description, this.headquartersLocation, this.id, this.logoPath, this.name, this.productName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentProcessor {\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    headquartersLocation: ").append(this.toIndentedString(this.headquartersLocation)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    logoPath: ").append(this.toIndentedString(this.logoPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

