/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.DataCollectionType;
import ch.postfinance.sdk.model.OneClickPaymentMode;
import ch.postfinance.sdk.model.ResourcePath;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The payment method configuration builds the base to connect with different payment method connectors.")
public class PaymentMethodConfiguration {
    @JsonProperty(value="dataCollectionType")
    protected DataCollectionType dataCollectionType = null;
    @JsonProperty(value="description")
    protected Map<String, String> description = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="imageResourcePath")
    protected ResourcePath imageResourcePath = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="oneClickPaymentMode")
    protected OneClickPaymentMode oneClickPaymentMode = null;
    @JsonProperty(value="paymentMethod")
    protected Long paymentMethod = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="resolvedDescription")
    protected Map<String, String> resolvedDescription = null;
    @JsonProperty(value="resolvedImageUrl")
    protected String resolvedImageUrl = null;
    @JsonProperty(value="resolvedTitle")
    protected Map<String, String> resolvedTitle = null;
    @JsonProperty(value="sortOrder")
    protected Integer sortOrder = null;
    @JsonProperty(value="spaceId")
    protected Long spaceId = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="title")
    protected Map<String, String> title = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The data collection type specifies how the payment information is collected.")
    public DataCollectionType getDataCollectionType() {
        return this.dataCollectionType;
    }

    @ApiModelProperty(value="A custom description for the payment method which is displayed to the customer.")
    public Map<String, String> getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The resource path to a custom image for the payment method which is displayed to the customer.")
    public ResourcePath getImageResourcePath() {
        return this.imageResourcePath;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The name used to identify the payment method configuration.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The one-click payment mode determines whether the customer can save their payment details for later payments.")
    public OneClickPaymentMode getOneClickPaymentMode() {
        return this.oneClickPaymentMode;
    }

    @ApiModelProperty(value="The payment method that the configuration is for.")
    public Long getPaymentMethod() {
        return this.paymentMethod;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The description for the payment method that is actually displayed to the customer. This is either the custom description, if defined, or otherwise the payment method's default one.")
    public Map<String, String> getResolvedDescription() {
        return this.resolvedDescription;
    }

    @ApiModelProperty(value="The image URL for the payment method that is actually displayed to the customer. This is either the custom image, if defined, or otherwise the payment method's default one.")
    public String getResolvedImageUrl() {
        return this.resolvedImageUrl;
    }

    @ApiModelProperty(value="The title for the payment method that is actually displayed to the customer. This is either the custom title, if defined, or otherwise the payment method's default one.")
    public Map<String, String> getResolvedTitle() {
        return this.resolvedTitle;
    }

    @ApiModelProperty(value="When listing payment methods, they can be sorted by this number.")
    public Integer getSortOrder() {
        return this.sortOrder;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getSpaceId() {
        return this.spaceId;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="A custom title for the payment method which is displayed to the customer.")
    public Map<String, String> getTitle() {
        return this.title;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodConfiguration paymentMethodConfiguration = (PaymentMethodConfiguration)o;
        return Objects.equals((Object)this.dataCollectionType, (Object)paymentMethodConfiguration.dataCollectionType) && Objects.equals(this.description, paymentMethodConfiguration.description) && Objects.equals(this.id, paymentMethodConfiguration.id) && Objects.equals(this.imageResourcePath, paymentMethodConfiguration.imageResourcePath) && Objects.equals(this.linkedSpaceId, paymentMethodConfiguration.linkedSpaceId) && Objects.equals(this.name, paymentMethodConfiguration.name) && Objects.equals((Object)this.oneClickPaymentMode, (Object)paymentMethodConfiguration.oneClickPaymentMode) && Objects.equals(this.paymentMethod, paymentMethodConfiguration.paymentMethod) && Objects.equals(this.plannedPurgeDate, paymentMethodConfiguration.plannedPurgeDate) && Objects.equals(this.resolvedDescription, paymentMethodConfiguration.resolvedDescription) && Objects.equals(this.resolvedImageUrl, paymentMethodConfiguration.resolvedImageUrl) && Objects.equals(this.resolvedTitle, paymentMethodConfiguration.resolvedTitle) && Objects.equals(this.sortOrder, paymentMethodConfiguration.sortOrder) && Objects.equals(this.spaceId, paymentMethodConfiguration.spaceId) && Objects.equals((Object)this.state, (Object)paymentMethodConfiguration.state) && Objects.equals(this.title, paymentMethodConfiguration.title) && Objects.equals(this.version, paymentMethodConfiguration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataCollectionType, this.description, this.id, this.imageResourcePath, this.linkedSpaceId, this.name, this.oneClickPaymentMode, this.paymentMethod, this.plannedPurgeDate, this.resolvedDescription, this.resolvedImageUrl, this.resolvedTitle, this.sortOrder, this.spaceId, this.state, this.title, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodConfiguration {\n");
        sb.append("    dataCollectionType: ").append(this.toIndentedString((Object)this.dataCollectionType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    imageResourcePath: ").append(this.toIndentedString(this.imageResourcePath)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    oneClickPaymentMode: ").append(this.toIndentedString((Object)this.oneClickPaymentMode)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    resolvedDescription: ").append(this.toIndentedString(this.resolvedDescription)).append("\n");
        sb.append("    resolvedImageUrl: ").append(this.toIndentedString(this.resolvedImageUrl)).append("\n");
        sb.append("    resolvedTitle: ").append(this.toIndentedString(this.resolvedTitle)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString(this.sortOrder)).append("\n");
        sb.append("    spaceId: ").append(this.toIndentedString(this.spaceId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

