/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.LineItem;
import ch.postfinance.sdk.model.PaymentLinkAddressHandlingMode;
import ch.postfinance.sdk.model.PaymentLinkProtectionMode;
import ch.postfinance.sdk.model.PaymentMethodConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The payment link defines an URL to automatically create transactions.")
public class PaymentLink {
    @JsonProperty(value="allowedPaymentMethodConfigurations")
    protected List<PaymentMethodConfiguration> allowedPaymentMethodConfigurations = null;
    @JsonProperty(value="appliedSpaceView")
    protected Long appliedSpaceView = null;
    @JsonProperty(value="availableFrom")
    protected OffsetDateTime availableFrom = null;
    @JsonProperty(value="availableUntil")
    protected OffsetDateTime availableUntil = null;
    @JsonProperty(value="billingAddressHandlingMode")
    protected PaymentLinkAddressHandlingMode billingAddressHandlingMode = null;
    @JsonProperty(value="currency")
    protected String currency = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItem> lineItems = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="maximalNumberOfTransactions")
    protected Integer maximalNumberOfTransactions = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="protectionMode")
    protected PaymentLinkProtectionMode protectionMode = null;
    @JsonProperty(value="shippingAddressHandlingMode")
    protected PaymentLinkAddressHandlingMode shippingAddressHandlingMode = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="url")
    protected String url = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The allowed payment method configurations restrict the payment methods which can be used with this payment link.")
    public List<PaymentMethodConfiguration> getAllowedPaymentMethodConfigurations() {
        return this.allowedPaymentMethodConfigurations;
    }

    @ApiModelProperty(value="The payment link can be conducted in a specific space view. The space view may apply a specific design to the payment page.")
    public Long getAppliedSpaceView() {
        return this.appliedSpaceView;
    }

    @ApiModelProperty(value="The available from date defines the earliest date on which the payment link can be used. When no date is specified there will be no restriction.")
    public OffsetDateTime getAvailableFrom() {
        return this.availableFrom;
    }

    @ApiModelProperty(value="The available from date defines the latest date on which the payment link can be used to initialize a transaction. When no date is specified there will be no restriction.")
    public OffsetDateTime getAvailableUntil() {
        return this.availableUntil;
    }

    @ApiModelProperty(value="The billing address handling mode controls if the address is collected or not and how it is collected.")
    public PaymentLinkAddressHandlingMode getBillingAddressHandlingMode() {
        return this.billingAddressHandlingMode;
    }

    @ApiModelProperty(value="The currency defines in which currency the payment is executed in. If no currency is defined it has to be specified within the request parameter 'currency'.")
    public String getCurrency() {
        return this.currency;
    }

    @ApiModelProperty(value="A client generated nonce which identifies the entity to be created. Subsequent creation requests with the same external ID will not create new entities but return the initially created entity instead.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The language defines the language of the payment page. If no language is provided it can be provided through the request parameter.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The line items allows to define the line items for this payment link. When the line items are defined they cannot be overridden through the request parameters. If no amount for the payment link is defined, the additional checkout page to enter the amount is shown to the consumer.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The maximal number of transactions limits the number of transactions which can be created with this payment link.")
    public Integer getMaximalNumberOfTransactions() {
        return this.maximalNumberOfTransactions;
    }

    @ApiModelProperty(value="The payment link name is used internally to identify the payment link. For example the name is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The protection mode determines if the payment link is protected against tampering and in what way.")
    public PaymentLinkProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    @ApiModelProperty(value="The shipping address handling mode controls if the address is collected or not and how it is collected.")
    public PaymentLinkAddressHandlingMode getShippingAddressHandlingMode() {
        return this.shippingAddressHandlingMode;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The URL defines the URL to which the user has to be forwarded to initialize the payment.")
    public String getUrl() {
        return this.url;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentLink paymentLink = (PaymentLink)o;
        return Objects.equals(this.allowedPaymentMethodConfigurations, paymentLink.allowedPaymentMethodConfigurations) && Objects.equals(this.appliedSpaceView, paymentLink.appliedSpaceView) && Objects.equals(this.availableFrom, paymentLink.availableFrom) && Objects.equals(this.availableUntil, paymentLink.availableUntil) && Objects.equals((Object)this.billingAddressHandlingMode, (Object)paymentLink.billingAddressHandlingMode) && Objects.equals(this.currency, paymentLink.currency) && Objects.equals(this.externalId, paymentLink.externalId) && Objects.equals(this.id, paymentLink.id) && Objects.equals(this.language, paymentLink.language) && Objects.equals(this.lineItems, paymentLink.lineItems) && Objects.equals(this.linkedSpaceId, paymentLink.linkedSpaceId) && Objects.equals(this.maximalNumberOfTransactions, paymentLink.maximalNumberOfTransactions) && Objects.equals(this.name, paymentLink.name) && Objects.equals(this.plannedPurgeDate, paymentLink.plannedPurgeDate) && Objects.equals((Object)this.protectionMode, (Object)paymentLink.protectionMode) && Objects.equals((Object)this.shippingAddressHandlingMode, (Object)paymentLink.shippingAddressHandlingMode) && Objects.equals((Object)this.state, (Object)paymentLink.state) && Objects.equals(this.url, paymentLink.url) && Objects.equals(this.version, paymentLink.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethodConfigurations, this.appliedSpaceView, this.availableFrom, this.availableUntil, this.billingAddressHandlingMode, this.currency, this.externalId, this.id, this.language, this.lineItems, this.linkedSpaceId, this.maximalNumberOfTransactions, this.name, this.plannedPurgeDate, this.protectionMode, this.shippingAddressHandlingMode, this.state, this.url, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentLink {\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    appliedSpaceView: ").append(this.toIndentedString(this.appliedSpaceView)).append("\n");
        sb.append("    availableFrom: ").append(this.toIndentedString(this.availableFrom)).append("\n");
        sb.append("    availableUntil: ").append(this.toIndentedString(this.availableUntil)).append("\n");
        sb.append("    billingAddressHandlingMode: ").append(this.toIndentedString((Object)this.billingAddressHandlingMode)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    maximalNumberOfTransactions: ").append(this.toIndentedString(this.maximalNumberOfTransactions)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    protectionMode: ").append(this.toIndentedString((Object)this.protectionMode)).append("\n");
        sb.append("    shippingAddressHandlingMode: ").append(this.toIndentedString((Object)this.shippingAddressHandlingMode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

