/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Account;
import ch.postfinance.sdk.model.FailureReason;
import ch.postfinance.sdk.model.PaymentContractState;
import ch.postfinance.sdk.model.PaymentContractType;
import ch.postfinance.sdk.model.User;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class PaymentContract {
    @JsonProperty(value="account")
    protected Account account = null;
    @JsonProperty(value="activatedOn")
    protected OffsetDateTime activatedOn = null;
    @JsonProperty(value="contractIdentifier")
    protected String contractIdentifier = null;
    @JsonProperty(value="contractType")
    protected PaymentContractType contractType = null;
    @JsonProperty(value="createdBy")
    protected User createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="lastModifiedDate")
    protected OffsetDateTime lastModifiedDate = null;
    @JsonProperty(value="rejectedOn")
    protected OffsetDateTime rejectedOn = null;
    @JsonProperty(value="rejectionReason")
    protected FailureReason rejectionReason = null;
    @JsonProperty(value="startTerminatingOn")
    protected OffsetDateTime startTerminatingOn = null;
    @JsonProperty(value="state")
    protected PaymentContractState state = null;
    @JsonProperty(value="terminatedBy")
    protected User terminatedBy = null;
    @JsonProperty(value="terminatedOn")
    protected OffsetDateTime terminatedOn = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="This account that the contract belongs to.")
    public Account getAccount() {
        return this.account;
    }

    @ApiModelProperty(value="The date and time when the contract was activated.")
    public OffsetDateTime getActivatedOn() {
        return this.activatedOn;
    }

    @ApiModelProperty(value="The identifier of the contract.")
    public String getContractIdentifier() {
        return this.contractIdentifier;
    }

    @ApiModelProperty(value="The type of the contract.")
    public PaymentContractType getContractType() {
        return this.contractType;
    }

    @ApiModelProperty(value="The ID of the user the contract was created by.")
    public User getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The date and time when the object was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="A client generated nonce which identifies the entity to be created. Subsequent creation requests with the same external ID will not create new entities but return the initially created entity instead.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The date and time when the object was last modified.")
    public OffsetDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @ApiModelProperty(value="The date and time when the contract was rejected.")
    public OffsetDateTime getRejectedOn() {
        return this.rejectedOn;
    }

    @ApiModelProperty(value="The reason for rejecting the contract.")
    public FailureReason getRejectionReason() {
        return this.rejectionReason;
    }

    @ApiModelProperty(value="The date and time when the termination process of the contract was started.")
    public OffsetDateTime getStartTerminatingOn() {
        return this.startTerminatingOn;
    }

    @ApiModelProperty(value="The object's current state.")
    public PaymentContractState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The ID of the user the contract was terminated by.")
    public User getTerminatedBy() {
        return this.terminatedBy;
    }

    @ApiModelProperty(value="The date and time when the contract was terminated.")
    public OffsetDateTime getTerminatedOn() {
        return this.terminatedOn;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentContract paymentContract = (PaymentContract)o;
        return Objects.equals(this.account, paymentContract.account) && Objects.equals(this.activatedOn, paymentContract.activatedOn) && Objects.equals(this.contractIdentifier, paymentContract.contractIdentifier) && Objects.equals(this.contractType, paymentContract.contractType) && Objects.equals(this.createdBy, paymentContract.createdBy) && Objects.equals(this.createdOn, paymentContract.createdOn) && Objects.equals(this.externalId, paymentContract.externalId) && Objects.equals(this.id, paymentContract.id) && Objects.equals(this.lastModifiedDate, paymentContract.lastModifiedDate) && Objects.equals(this.rejectedOn, paymentContract.rejectedOn) && Objects.equals(this.rejectionReason, paymentContract.rejectionReason) && Objects.equals(this.startTerminatingOn, paymentContract.startTerminatingOn) && Objects.equals((Object)this.state, (Object)paymentContract.state) && Objects.equals(this.terminatedBy, paymentContract.terminatedBy) && Objects.equals(this.terminatedOn, paymentContract.terminatedOn) && Objects.equals(this.version, paymentContract.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.activatedOn, this.contractIdentifier, this.contractType, this.createdBy, this.createdOn, this.externalId, this.id, this.lastModifiedDate, this.rejectedOn, this.rejectionReason, this.startTerminatingOn, this.state, this.terminatedBy, this.terminatedOn, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentContract {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    activatedOn: ").append(this.toIndentedString(this.activatedOn)).append("\n");
        sb.append("    contractIdentifier: ").append(this.toIndentedString(this.contractIdentifier)).append("\n");
        sb.append("    contractType: ").append(this.toIndentedString(this.contractType)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastModifiedDate: ").append(this.toIndentedString(this.lastModifiedDate)).append("\n");
        sb.append("    rejectedOn: ").append(this.toIndentedString(this.rejectedOn)).append("\n");
        sb.append("    rejectionReason: ").append(this.toIndentedString(this.rejectionReason)).append("\n");
        sb.append("    startTerminatingOn: ").append(this.toIndentedString(this.startTerminatingOn)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    terminatedBy: ").append(this.toIndentedString(this.terminatedBy)).append("\n");
        sb.append("    terminatedOn: ").append(this.toIndentedString(this.terminatedOn)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

