/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.PaymentMethodConfiguration;
import ch.postfinance.sdk.model.PaymentProcessorConfiguration;
import ch.postfinance.sdk.model.SalesChannel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class PaymentConnectorConfiguration {
    @JsonProperty(value="applicableForTransactionProcessing")
    protected Boolean applicableForTransactionProcessing = null;
    @JsonProperty(value="conditions")
    protected List<Long> conditions = null;
    @JsonProperty(value="connector")
    protected Long connector = null;
    @JsonProperty(value="enabledSalesChannels")
    protected List<SalesChannel> enabledSalesChannels = null;
    @JsonProperty(value="enabledSpaceViews")
    protected List<Long> enabledSpaceViews = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="imagePath")
    protected String imagePath = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="paymentMethodConfiguration")
    protected PaymentMethodConfiguration paymentMethodConfiguration = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="priority")
    protected Integer priority = null;
    @JsonProperty(value="processorConfiguration")
    protected PaymentProcessorConfiguration processorConfiguration = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="Whether this connector configuration is enabled for processing payments, taking into account the state of the processor and payment method configurations.")
    public Boolean isApplicableForTransactionProcessing() {
        return this.applicableForTransactionProcessing;
    }

    @ApiModelProperty(value="Conditions allow to define criteria that a transaction must fulfill in order for the connector configuration to be considered for processing the payment.")
    public List<Long> getConditions() {
        return this.conditions;
    }

    @ApiModelProperty(value="The connector that the configuration is for.")
    public Long getConnector() {
        return this.connector;
    }

    @ApiModelProperty(value="The sales channels for which the connector configuration is enabled. If empty, it is enabled for all sales channels.")
    public List<SalesChannel> getEnabledSalesChannels() {
        return this.enabledSalesChannels;
    }

    @ApiModelProperty(value="The space views for which the connector configuration is enabled. If empty, it is enabled for all space views.")
    public List<Long> getEnabledSpaceViews() {
        return this.enabledSpaceViews;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The URL to the connector's image.")
    public String getImagePath() {
        return this.imagePath;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The name used to identify the connector configuration.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The payment method configuration that the connector configuration belongs to.")
    public PaymentMethodConfiguration getPaymentMethodConfiguration() {
        return this.paymentMethodConfiguration;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The priority that determines the order in which connector configurations are taken into account when processing a payment. Low values are considered first.")
    public Integer getPriority() {
        return this.priority;
    }

    @ApiModelProperty(value="The processor configuration that the connector configuration belongs to.")
    public PaymentProcessorConfiguration getProcessorConfiguration() {
        return this.processorConfiguration;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentConnectorConfiguration paymentConnectorConfiguration = (PaymentConnectorConfiguration)o;
        return Objects.equals(this.applicableForTransactionProcessing, paymentConnectorConfiguration.applicableForTransactionProcessing) && Objects.equals(this.conditions, paymentConnectorConfiguration.conditions) && Objects.equals(this.connector, paymentConnectorConfiguration.connector) && Objects.equals(this.enabledSalesChannels, paymentConnectorConfiguration.enabledSalesChannels) && Objects.equals(this.enabledSpaceViews, paymentConnectorConfiguration.enabledSpaceViews) && Objects.equals(this.id, paymentConnectorConfiguration.id) && Objects.equals(this.imagePath, paymentConnectorConfiguration.imagePath) && Objects.equals(this.linkedSpaceId, paymentConnectorConfiguration.linkedSpaceId) && Objects.equals(this.name, paymentConnectorConfiguration.name) && Objects.equals(this.paymentMethodConfiguration, paymentConnectorConfiguration.paymentMethodConfiguration) && Objects.equals(this.plannedPurgeDate, paymentConnectorConfiguration.plannedPurgeDate) && Objects.equals(this.priority, paymentConnectorConfiguration.priority) && Objects.equals(this.processorConfiguration, paymentConnectorConfiguration.processorConfiguration) && Objects.equals((Object)this.state, (Object)paymentConnectorConfiguration.state) && Objects.equals(this.version, paymentConnectorConfiguration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicableForTransactionProcessing, this.conditions, this.connector, this.enabledSalesChannels, this.enabledSpaceViews, this.id, this.imagePath, this.linkedSpaceId, this.name, this.paymentMethodConfiguration, this.plannedPurgeDate, this.priority, this.processorConfiguration, this.state, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentConnectorConfiguration {\n");
        sb.append("    applicableForTransactionProcessing: ").append(this.toIndentedString(this.applicableForTransactionProcessing)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    connector: ").append(this.toIndentedString(this.connector)).append("\n");
        sb.append("    enabledSalesChannels: ").append(this.toIndentedString(this.enabledSalesChannels)).append("\n");
        sb.append("    enabledSpaceViews: ").append(this.toIndentedString(this.enabledSpaceViews)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    imagePath: ").append(this.toIndentedString(this.imagePath)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    paymentMethodConfiguration: ").append(this.toIndentedString(this.paymentMethodConfiguration)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    processorConfiguration: ").append(this.toIndentedString(this.processorConfiguration)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

