/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.ManualTaskState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A manual task requires the manual intervention of a human.")
public class ManualTask {
    @JsonProperty(value="actions")
    protected List<Long> actions = null;
    @JsonProperty(value="contextEntityId")
    protected Long contextEntityId = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="expiresOn")
    protected OffsetDateTime expiresOn = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected ManualTaskState state = null;
    @JsonProperty(value="type")
    protected Long type = null;

    @ApiModelProperty(value="The actions that can be triggered to handle the manual task.")
    public List<Long> getActions() {
        return this.actions;
    }

    @ApiModelProperty(value="The ID of the entity the manual task is linked to.")
    public Long getContextEntityId() {
        return this.contextEntityId;
    }

    @ApiModelProperty(value="The date and time when the object was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The date and time until when the manual task has to be handled.")
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public ManualTaskState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The manual task's type.")
    public Long getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualTask manualTask = (ManualTask)o;
        return Objects.equals(this.actions, manualTask.actions) && Objects.equals(this.contextEntityId, manualTask.contextEntityId) && Objects.equals(this.createdOn, manualTask.createdOn) && Objects.equals(this.expiresOn, manualTask.expiresOn) && Objects.equals(this.id, manualTask.id) && Objects.equals(this.linkedSpaceId, manualTask.linkedSpaceId) && Objects.equals(this.plannedPurgeDate, manualTask.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)manualTask.state) && Objects.equals(this.type, manualTask.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actions, this.contextEntityId, this.createdOn, this.expiresOn, this.id, this.linkedSpaceId, this.plannedPurgeDate, this.state, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManualTask {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    contextEntityId: ").append(this.toIndentedString(this.contextEntityId)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    expiresOn: ").append(this.toIndentedString(this.expiresOn)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

