/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="")
public class Customer {
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="customerId")
    protected String customerId = null;
    @JsonProperty(value="emailAddress")
    protected String emailAddress = null;
    @JsonProperty(value="familyName")
    protected String familyName = null;
    @JsonProperty(value="givenName")
    protected String givenName = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="metaData")
    protected Map<String, String> metaData = null;
    @JsonProperty(value="preferredCurrency")
    protected String preferredCurrency = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The date and time when the object was created.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The customer's ID in the merchant's system.")
    public String getCustomerId() {
        return this.customerId;
    }

    @ApiModelProperty(value="The customer's email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @ApiModelProperty(value="The customer's family or last name.")
    public String getFamilyName() {
        return this.familyName;
    }

    @ApiModelProperty(value="The customer's given or first name.")
    public String getGivenName() {
        return this.givenName;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="Allow to store additional information about the object.")
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    @ApiModelProperty(value="The customer's preferred currency.")
    public String getPreferredCurrency() {
        return this.preferredCurrency;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.createdOn, customer.createdOn) && Objects.equals(this.customerId, customer.customerId) && Objects.equals(this.emailAddress, customer.emailAddress) && Objects.equals(this.familyName, customer.familyName) && Objects.equals(this.givenName, customer.givenName) && Objects.equals(this.id, customer.id) && Objects.equals(this.language, customer.language) && Objects.equals(this.linkedSpaceId, customer.linkedSpaceId) && Objects.equals(this.metaData, customer.metaData) && Objects.equals(this.preferredCurrency, customer.preferredCurrency) && Objects.equals(this.version, customer.version);
    }

    public int hashCode() {
        return Objects.hash(this.createdOn, this.customerId, this.emailAddress, this.familyName, this.givenName, this.id, this.language, this.linkedSpaceId, this.metaData, this.preferredCurrency, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Customer {\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    metaData: ").append(this.toIndentedString(this.metaData)).append("\n");
        sb.append("    preferredCurrency: ").append(this.toIndentedString(this.preferredCurrency)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

