/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="A condition allows you to define a criteria that a transaction must fulfill in order for a connector configuration to be considered for processing the payment.")
public class Condition {
    @JsonProperty(value="conditionType")
    protected Long conditionType = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The condition type determines the criteria that a transaction must fulfill in order for a connector configuration to be considered for processing the payment.")
    public Long getConditionType() {
        return this.conditionType;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The name used to identify the condition.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.conditionType, condition.conditionType) && Objects.equals(this.id, condition.id) && Objects.equals(this.linkedSpaceId, condition.linkedSpaceId) && Objects.equals(this.name, condition.name) && Objects.equals(this.plannedPurgeDate, condition.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)condition.state) && Objects.equals(this.version, condition.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditionType, this.id, this.linkedSpaceId, this.name, this.plannedPurgeDate, this.state, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Condition {\n");
        sb.append("    conditionType: ").append(this.toIndentedString(this.conditionType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

