/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.ChargeState;
import ch.postfinance.sdk.model.ChargeType;
import ch.postfinance.sdk.model.FailureReason;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionAwareEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class Charge
extends TransactionAwareEntity {
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="failureReason")
    protected FailureReason failureReason = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="state")
    protected ChargeState state = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="timeoutOn")
    protected OffsetDateTime timeoutOn = null;
    @JsonProperty(value="transaction")
    protected Transaction transaction = null;
    @JsonProperty(value="type")
    protected ChargeType type = null;
    @JsonProperty(value="userFailureMessage")
    protected String userFailureMessage = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The date on which the charge was created on.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The ID of the space view this object is linked to.")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="The object's current state.")
    public ChargeState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getTimeoutOn() {
        return this.timeoutOn;
    }

    @ApiModelProperty(value="")
    public Transaction getTransaction() {
        return this.transaction;
    }

    @ApiModelProperty(value="")
    public ChargeType getType() {
        return this.type;
    }

    @ApiModelProperty(value="The failure message describes for an end user why the charge is failed in the language of the user. This is only provided when the charge is marked as failed.")
    public String getUserFailureMessage() {
        return this.userFailureMessage;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Charge charge = (Charge)o;
        return Objects.equals(this.id, charge.id) && Objects.equals(this.linkedSpaceId, charge.linkedSpaceId) && Objects.equals(this.linkedTransaction, charge.linkedTransaction) && Objects.equals(this.createdOn, charge.createdOn) && Objects.equals(this.failureReason, charge.failureReason) && Objects.equals(this.language, charge.language) && Objects.equals(this.plannedPurgeDate, charge.plannedPurgeDate) && Objects.equals(this.spaceViewId, charge.spaceViewId) && Objects.equals((Object)this.state, (Object)charge.state) && Objects.equals(this.timeZone, charge.timeZone) && Objects.equals(this.timeoutOn, charge.timeoutOn) && Objects.equals(this.transaction, charge.transaction) && Objects.equals((Object)this.type, (Object)charge.type) && Objects.equals(this.userFailureMessage, charge.userFailureMessage) && Objects.equals(this.version, charge.version) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.linkedSpaceId, this.linkedTransaction, this.createdOn, this.failureReason, this.language, this.plannedPurgeDate, this.spaceViewId, this.state, this.timeZone, this.timeoutOn, this.transaction, this.type, this.userFailureMessage, this.version, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Charge {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    linkedTransaction: ").append(this.toIndentedString(this.linkedTransaction)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    timeoutOn: ").append(this.toIndentedString(this.timeoutOn)).append("\n");
        sb.append("    transaction: ").append(this.toIndentedString(this.transaction)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    userFailureMessage: ").append(this.toIndentedString(this.userFailureMessage)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

