/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CardAuthenticationResponse;
import ch.postfinance.sdk.model.CardAuthenticationVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This model holds the cardholder authentication data (e.g. 3-D Secure authentication).")
public class CardholderAuthenticationCreate {
    @JsonProperty(value="authenticationIdentifier")
    protected String authenticationIdentifier = null;
    @JsonProperty(value="authenticationResponse")
    protected CardAuthenticationResponse authenticationResponse = null;
    @JsonProperty(value="authenticationValue")
    protected String authenticationValue = null;
    @JsonProperty(value="electronicCommerceIndicator")
    protected String electronicCommerceIndicator = null;
    @JsonProperty(value="version")
    protected CardAuthenticationVersion version = null;

    public CardholderAuthenticationCreate authenticationIdentifier(String authenticationIdentifier) {
        this.authenticationIdentifier = authenticationIdentifier;
        return this;
    }

    @ApiModelProperty(value="The authentication identifier as assigned by authentication system (e.g. XID or DSTransactionID).")
    public String getAuthenticationIdentifier() {
        return this.authenticationIdentifier;
    }

    public void setAuthenticationIdentifier(String authenticationIdentifier) {
        this.authenticationIdentifier = authenticationIdentifier;
    }

    public CardholderAuthenticationCreate authenticationResponse(CardAuthenticationResponse authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CardAuthenticationResponse getAuthenticationResponse() {
        return this.authenticationResponse;
    }

    public void setAuthenticationResponse(CardAuthenticationResponse authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
    }

    public CardholderAuthenticationCreate authenticationValue(String authenticationValue) {
        this.authenticationValue = authenticationValue;
        return this;
    }

    @ApiModelProperty(value="The cardholder authentication value. Also known as Cardholder Authentication Verification Value (CAVV).")
    public String getAuthenticationValue() {
        return this.authenticationValue;
    }

    public void setAuthenticationValue(String authenticationValue) {
        this.authenticationValue = authenticationValue;
    }

    public CardholderAuthenticationCreate electronicCommerceIndicator(String electronicCommerceIndicator) {
        this.electronicCommerceIndicator = electronicCommerceIndicator;
        return this;
    }

    @ApiModelProperty(value="The Electronic Commerce Indicator (ECI) value. The ECI is returned by authentication system and indicates the outcome/status of authentication.")
    public String getElectronicCommerceIndicator() {
        return this.electronicCommerceIndicator;
    }

    public void setElectronicCommerceIndicator(String electronicCommerceIndicator) {
        this.electronicCommerceIndicator = electronicCommerceIndicator;
    }

    public CardholderAuthenticationCreate version(CardAuthenticationVersion version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CardAuthenticationVersion getVersion() {
        return this.version;
    }

    public void setVersion(CardAuthenticationVersion version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardholderAuthenticationCreate cardholderAuthenticationCreate = (CardholderAuthenticationCreate)o;
        return Objects.equals(this.authenticationIdentifier, cardholderAuthenticationCreate.authenticationIdentifier) && Objects.equals((Object)this.authenticationResponse, (Object)cardholderAuthenticationCreate.authenticationResponse) && Objects.equals(this.authenticationValue, cardholderAuthenticationCreate.authenticationValue) && Objects.equals(this.electronicCommerceIndicator, cardholderAuthenticationCreate.electronicCommerceIndicator) && Objects.equals((Object)this.version, (Object)cardholderAuthenticationCreate.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationIdentifier, this.authenticationResponse, this.authenticationValue, this.electronicCommerceIndicator, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardholderAuthenticationCreate {\n");
        sb.append("    authenticationIdentifier: ").append(this.toIndentedString(this.authenticationIdentifier)).append("\n");
        sb.append("    authenticationResponse: ").append(this.toIndentedString((Object)this.authenticationResponse)).append("\n");
        sb.append("    authenticationValue: ").append(this.toIndentedString(this.authenticationValue)).append("\n");
        sb.append("    electronicCommerceIndicator: ").append(this.toIndentedString(this.electronicCommerceIndicator)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

