/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CardAuthenticationResponse;
import ch.postfinance.sdk.model.CardAuthenticationVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This model holds the cardholder authentication data (e.g. 3-D Secure authentication).")
public class CardholderAuthentication {
    @JsonProperty(value="authenticationIdentifier")
    protected String authenticationIdentifier = null;
    @JsonProperty(value="authenticationResponse")
    protected CardAuthenticationResponse authenticationResponse = null;
    @JsonProperty(value="authenticationValue")
    protected String authenticationValue = null;
    @JsonProperty(value="electronicCommerceIndicator")
    protected String electronicCommerceIndicator = null;
    @JsonProperty(value="version")
    protected CardAuthenticationVersion version = null;

    @ApiModelProperty(value="The authentication identifier as assigned by authentication system (e.g. XID or DSTransactionID).")
    public String getAuthenticationIdentifier() {
        return this.authenticationIdentifier;
    }

    @ApiModelProperty(value="")
    public CardAuthenticationResponse getAuthenticationResponse() {
        return this.authenticationResponse;
    }

    @ApiModelProperty(value="The cardholder authentication value. Also known as Cardholder Authentication Verification Value (CAVV).")
    public String getAuthenticationValue() {
        return this.authenticationValue;
    }

    @ApiModelProperty(value="The Electronic Commerce Indicator (ECI) value. The ECI is returned by authentication system and indicates the outcome/status of authentication.")
    public String getElectronicCommerceIndicator() {
        return this.electronicCommerceIndicator;
    }

    @ApiModelProperty(value="")
    public CardAuthenticationVersion getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardholderAuthentication cardholderAuthentication = (CardholderAuthentication)o;
        return Objects.equals(this.authenticationIdentifier, cardholderAuthentication.authenticationIdentifier) && Objects.equals((Object)this.authenticationResponse, (Object)cardholderAuthentication.authenticationResponse) && Objects.equals(this.authenticationValue, cardholderAuthentication.authenticationValue) && Objects.equals(this.electronicCommerceIndicator, cardholderAuthentication.electronicCommerceIndicator) && Objects.equals((Object)this.version, (Object)cardholderAuthentication.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationIdentifier, this.authenticationResponse, this.authenticationValue, this.electronicCommerceIndicator, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardholderAuthentication {\n");
        sb.append("    authenticationIdentifier: ").append(this.toIndentedString(this.authenticationIdentifier)).append("\n");
        sb.append("    authenticationResponse: ").append(this.toIndentedString((Object)this.authenticationResponse)).append("\n");
        sb.append("    authenticationValue: ").append(this.toIndentedString(this.authenticationValue)).append("\n");
        sb.append("    electronicCommerceIndicator: ").append(this.toIndentedString(this.electronicCommerceIndicator)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

