/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.ShopifySubscriptionBillingIntervalUnit;
import ch.postfinance.sdk.model.ShopifySubscriptionWeekday;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class BillingConfiguration {
    @JsonProperty(value="billingDayOfMonth")
    protected Integer billingDayOfMonth = null;
    @JsonProperty(value="billingIntervalAmount")
    protected Integer billingIntervalAmount = null;
    @JsonProperty(value="billingIntervalUnit")
    protected ShopifySubscriptionBillingIntervalUnit billingIntervalUnit = null;
    @JsonProperty(value="billingReferenceDate")
    protected OffsetDateTime billingReferenceDate = null;
    @JsonProperty(value="billingWeekday")
    protected ShopifySubscriptionWeekday billingWeekday = null;
    @JsonProperty(value="maximalBillingCycles")
    protected Integer maximalBillingCycles = null;
    @JsonProperty(value="maximalSuspendableCycles")
    protected Integer maximalSuspendableCycles = null;
    @JsonProperty(value="minimalBillingCycles")
    protected Integer minimalBillingCycles = null;
    @JsonProperty(value="terminationBillingCycles")
    protected Integer terminationBillingCycles = null;

    public BillingConfiguration billingDayOfMonth(Integer billingDayOfMonth) {
        this.billingDayOfMonth = billingDayOfMonth;
        return this;
    }

    @ApiModelProperty(value="Define the day of the month on which the recurring orders should be created.")
    public Integer getBillingDayOfMonth() {
        return this.billingDayOfMonth;
    }

    public void setBillingDayOfMonth(Integer billingDayOfMonth) {
        this.billingDayOfMonth = billingDayOfMonth;
    }

    public BillingConfiguration billingIntervalAmount(Integer billingIntervalAmount) {
        this.billingIntervalAmount = billingIntervalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getBillingIntervalAmount() {
        return this.billingIntervalAmount;
    }

    public void setBillingIntervalAmount(Integer billingIntervalAmount) {
        this.billingIntervalAmount = billingIntervalAmount;
    }

    public BillingConfiguration billingIntervalUnit(ShopifySubscriptionBillingIntervalUnit billingIntervalUnit) {
        this.billingIntervalUnit = billingIntervalUnit;
        return this;
    }

    @ApiModelProperty(value="Define how frequently recurring orders should be created.")
    public ShopifySubscriptionBillingIntervalUnit getBillingIntervalUnit() {
        return this.billingIntervalUnit;
    }

    public void setBillingIntervalUnit(ShopifySubscriptionBillingIntervalUnit billingIntervalUnit) {
        this.billingIntervalUnit = billingIntervalUnit;
    }

    public BillingConfiguration billingReferenceDate(OffsetDateTime billingReferenceDate) {
        this.billingReferenceDate = billingReferenceDate;
        return this;
    }

    @ApiModelProperty(value="This date will be used as basis to calculate the dates of recurring orders.")
    public OffsetDateTime getBillingReferenceDate() {
        return this.billingReferenceDate;
    }

    public void setBillingReferenceDate(OffsetDateTime billingReferenceDate) {
        this.billingReferenceDate = billingReferenceDate;
    }

    public BillingConfiguration billingWeekday(ShopifySubscriptionWeekday billingWeekday) {
        this.billingWeekday = billingWeekday;
        return this;
    }

    @ApiModelProperty(value="Define the weekday on which the recurring orders should be created.")
    public ShopifySubscriptionWeekday getBillingWeekday() {
        return this.billingWeekday;
    }

    public void setBillingWeekday(ShopifySubscriptionWeekday billingWeekday) {
        this.billingWeekday = billingWeekday;
    }

    public BillingConfiguration maximalBillingCycles(Integer maximalBillingCycles) {
        this.maximalBillingCycles = maximalBillingCycles;
        return this;
    }

    @ApiModelProperty(value="Define the maximum number of orders the subscription will run for.")
    public Integer getMaximalBillingCycles() {
        return this.maximalBillingCycles;
    }

    public void setMaximalBillingCycles(Integer maximalBillingCycles) {
        this.maximalBillingCycles = maximalBillingCycles;
    }

    public BillingConfiguration maximalSuspendableCycles(Integer maximalSuspendableCycles) {
        this.maximalSuspendableCycles = maximalSuspendableCycles;
        return this;
    }

    @ApiModelProperty(value="Define the maximum number of orders the subscription can be suspended for at a time.")
    public Integer getMaximalSuspendableCycles() {
        return this.maximalSuspendableCycles;
    }

    public void setMaximalSuspendableCycles(Integer maximalSuspendableCycles) {
        this.maximalSuspendableCycles = maximalSuspendableCycles;
    }

    public BillingConfiguration minimalBillingCycles(Integer minimalBillingCycles) {
        this.minimalBillingCycles = minimalBillingCycles;
        return this;
    }

    @ApiModelProperty(value="Define the minimal number of orders the subscription will run for.")
    public Integer getMinimalBillingCycles() {
        return this.minimalBillingCycles;
    }

    public void setMinimalBillingCycles(Integer minimalBillingCycles) {
        this.minimalBillingCycles = minimalBillingCycles;
    }

    public BillingConfiguration terminationBillingCycles(Integer terminationBillingCycles) {
        this.terminationBillingCycles = terminationBillingCycles;
        return this;
    }

    @ApiModelProperty(value="Define the number of orders the subscription will keep running for after its termination has been requested.")
    public Integer getTerminationBillingCycles() {
        return this.terminationBillingCycles;
    }

    public void setTerminationBillingCycles(Integer terminationBillingCycles) {
        this.terminationBillingCycles = terminationBillingCycles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingConfiguration billingConfiguration = (BillingConfiguration)o;
        return Objects.equals(this.billingDayOfMonth, billingConfiguration.billingDayOfMonth) && Objects.equals(this.billingIntervalAmount, billingConfiguration.billingIntervalAmount) && Objects.equals((Object)this.billingIntervalUnit, (Object)billingConfiguration.billingIntervalUnit) && Objects.equals(this.billingReferenceDate, billingConfiguration.billingReferenceDate) && Objects.equals((Object)this.billingWeekday, (Object)billingConfiguration.billingWeekday) && Objects.equals(this.maximalBillingCycles, billingConfiguration.maximalBillingCycles) && Objects.equals(this.maximalSuspendableCycles, billingConfiguration.maximalSuspendableCycles) && Objects.equals(this.minimalBillingCycles, billingConfiguration.minimalBillingCycles) && Objects.equals(this.terminationBillingCycles, billingConfiguration.terminationBillingCycles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.billingDayOfMonth, this.billingIntervalAmount, this.billingIntervalUnit, this.billingReferenceDate, this.billingWeekday, this.maximalBillingCycles, this.maximalSuspendableCycles, this.minimalBillingCycles, this.terminationBillingCycles});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingConfiguration {\n");
        sb.append("    billingDayOfMonth: ").append(this.toIndentedString(this.billingDayOfMonth)).append("\n");
        sb.append("    billingIntervalAmount: ").append(this.toIndentedString(this.billingIntervalAmount)).append("\n");
        sb.append("    billingIntervalUnit: ").append(this.toIndentedString((Object)this.billingIntervalUnit)).append("\n");
        sb.append("    billingReferenceDate: ").append(this.toIndentedString(this.billingReferenceDate)).append("\n");
        sb.append("    billingWeekday: ").append(this.toIndentedString((Object)this.billingWeekday)).append("\n");
        sb.append("    maximalBillingCycles: ").append(this.toIndentedString(this.maximalBillingCycles)).append("\n");
        sb.append("    maximalSuspendableCycles: ").append(this.toIndentedString(this.maximalSuspendableCycles)).append("\n");
        sb.append("    minimalBillingCycles: ").append(this.toIndentedString(this.minimalBillingCycles)).append("\n");
        sb.append("    terminationBillingCycles: ").append(this.toIndentedString(this.terminationBillingCycles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

