/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.BankAccountState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="")
public class BankAccount {
    @JsonProperty(value="description")
    protected String description = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="identifier")
    protected String identifier = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected BankAccountState state = null;
    @JsonProperty(value="type")
    protected Long type = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The optional description is shown along the identifier. The intention of the description is to give an alternative name to the bank account.")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="A unique identifier for the object.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The bank account identifier is responsible to uniquely identify the bank account.")
    public String getIdentifier() {
        return this.identifier;
    }

    @ApiModelProperty(value="The ID of the space this object belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The date and time when the object is planned to be permanently removed. If the value is empty, the object will not be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The object's current state.")
    public BankAccountState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public Long getType() {
        return this.type;
    }

    @ApiModelProperty(value="The version is used for optimistic locking and incremented whenever the object is updated.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)o;
        return Objects.equals(this.description, bankAccount.description) && Objects.equals(this.id, bankAccount.id) && Objects.equals(this.identifier, bankAccount.identifier) && Objects.equals(this.linkedSpaceId, bankAccount.linkedSpaceId) && Objects.equals(this.plannedPurgeDate, bankAccount.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)bankAccount.state) && Objects.equals(this.type, bankAccount.type) && Objects.equals(this.version, bankAccount.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.id, this.identifier, this.linkedSpaceId, this.plannedPurgeDate, this.state, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccount {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

