/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CardCryptogramCreate;
import ch.postfinance.sdk.model.CardholderAuthenticationCreate;
import ch.postfinance.sdk.model.RecurringIndicator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This model holds the card data and optional cardholder authentication details.")
public class AuthenticatedCardDataCreate {
    @JsonProperty(value="cardHolderName")
    protected String cardHolderName = null;
    @JsonProperty(value="cardVerificationCode")
    protected String cardVerificationCode = null;
    @JsonProperty(value="cardholderAuthentication")
    protected CardholderAuthenticationCreate cardholderAuthentication = null;
    @JsonProperty(value="cryptogram")
    protected CardCryptogramCreate cryptogram = null;
    @JsonProperty(value="expiryDate")
    protected String expiryDate = null;
    @JsonProperty(value="primaryAccountNumber")
    protected String primaryAccountNumber = null;
    @JsonProperty(value="recurringIndicator")
    protected RecurringIndicator recurringIndicator = null;
    @JsonProperty(value="schemeTransactionReference")
    protected String schemeTransactionReference = null;
    @JsonProperty(value="tokenRequestorId")
    protected String tokenRequestorId = null;

    public AuthenticatedCardDataCreate cardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
        return this;
    }

    @ApiModelProperty(value="The card holder name is the name printed onto the card. It identifies the person who owns the card.")
    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public AuthenticatedCardDataCreate cardVerificationCode(String cardVerificationCode) {
        this.cardVerificationCode = cardVerificationCode;
        return this;
    }

    @ApiModelProperty(value="The card verification code (CVC) is a 3 to 4 digit code typically printed on the back of the card. It helps to ensure that the card holder is authorizing the transaction. For card not-present transactions this field is optional.")
    public String getCardVerificationCode() {
        return this.cardVerificationCode;
    }

    public void setCardVerificationCode(String cardVerificationCode) {
        this.cardVerificationCode = cardVerificationCode;
    }

    public AuthenticatedCardDataCreate cardholderAuthentication(CardholderAuthenticationCreate cardholderAuthentication) {
        this.cardholderAuthentication = cardholderAuthentication;
        return this;
    }

    @ApiModelProperty(value="The cardholder authentication information. The authentication is optional and can be provided if the cardholder has been already authenticated (e.g. in 3-D Secure system).")
    public CardholderAuthenticationCreate getCardholderAuthentication() {
        return this.cardholderAuthentication;
    }

    public void setCardholderAuthentication(CardholderAuthenticationCreate cardholderAuthentication) {
        this.cardholderAuthentication = cardholderAuthentication;
    }

    public AuthenticatedCardDataCreate cryptogram(CardCryptogramCreate cryptogram) {
        this.cryptogram = cryptogram;
        return this;
    }

    @ApiModelProperty(value="The additional authentication value used to secure the tokenized card transactions.")
    public CardCryptogramCreate getCryptogram() {
        return this.cryptogram;
    }

    public void setCryptogram(CardCryptogramCreate cryptogram) {
        this.cryptogram = cryptogram;
    }

    public AuthenticatedCardDataCreate expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @ApiModelProperty(value="The card expiry date indicates when the card expires. The format is the format yyyy-mm where yyyy is the year (e.g. 2019) and the mm is the month (e.g. 09).")
    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public AuthenticatedCardDataCreate primaryAccountNumber(String primaryAccountNumber) {
        this.primaryAccountNumber = primaryAccountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The primary account number (PAN) identifies the card. The number is numeric and typically printed on the front of the card.")
    public String getPrimaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public void setPrimaryAccountNumber(String primaryAccountNumber) {
        this.primaryAccountNumber = primaryAccountNumber;
    }

    public AuthenticatedCardDataCreate recurringIndicator(RecurringIndicator recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
        return this;
    }

    @ApiModelProperty(value="")
    public RecurringIndicator getRecurringIndicator() {
        return this.recurringIndicator;
    }

    public void setRecurringIndicator(RecurringIndicator recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public AuthenticatedCardDataCreate schemeTransactionReference(String schemeTransactionReference) {
        this.schemeTransactionReference = schemeTransactionReference;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSchemeTransactionReference() {
        return this.schemeTransactionReference;
    }

    public void setSchemeTransactionReference(String schemeTransactionReference) {
        this.schemeTransactionReference = schemeTransactionReference;
    }

    public AuthenticatedCardDataCreate tokenRequestorId(String tokenRequestorId) {
        this.tokenRequestorId = tokenRequestorId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getTokenRequestorId() {
        return this.tokenRequestorId;
    }

    public void setTokenRequestorId(String tokenRequestorId) {
        this.tokenRequestorId = tokenRequestorId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatedCardDataCreate authenticatedCardDataCreate = (AuthenticatedCardDataCreate)o;
        return Objects.equals(this.cardHolderName, authenticatedCardDataCreate.cardHolderName) && Objects.equals(this.cardVerificationCode, authenticatedCardDataCreate.cardVerificationCode) && Objects.equals(this.cardholderAuthentication, authenticatedCardDataCreate.cardholderAuthentication) && Objects.equals(this.cryptogram, authenticatedCardDataCreate.cryptogram) && Objects.equals(this.expiryDate, authenticatedCardDataCreate.expiryDate) && Objects.equals(this.primaryAccountNumber, authenticatedCardDataCreate.primaryAccountNumber) && Objects.equals((Object)this.recurringIndicator, (Object)authenticatedCardDataCreate.recurringIndicator) && Objects.equals(this.schemeTransactionReference, authenticatedCardDataCreate.schemeTransactionReference) && Objects.equals(this.tokenRequestorId, authenticatedCardDataCreate.tokenRequestorId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cardHolderName, this.cardVerificationCode, this.cardholderAuthentication, this.cryptogram, this.expiryDate, this.primaryAccountNumber, this.recurringIndicator, this.schemeTransactionReference, this.tokenRequestorId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatedCardDataCreate {\n");
        sb.append("    cardHolderName: ").append(this.toIndentedString(this.cardHolderName)).append("\n");
        sb.append("    cardVerificationCode: ").append(this.toIndentedString(this.cardVerificationCode)).append("\n");
        sb.append("    cardholderAuthentication: ").append(this.toIndentedString(this.cardholderAuthentication)).append("\n");
        sb.append("    cryptogram: ").append(this.toIndentedString(this.cryptogram)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    primaryAccountNumber: ").append(this.toIndentedString(this.primaryAccountNumber)).append("\n");
        sb.append("    recurringIndicator: ").append(this.toIndentedString((Object)this.recurringIndicator)).append("\n");
        sb.append("    schemeTransactionReference: ").append(this.toIndentedString(this.schemeTransactionReference)).append("\n");
        sb.append("    tokenRequestorId: ").append(this.toIndentedString(this.tokenRequestorId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

