/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CardholderAuthentication;
import ch.postfinance.sdk.model.TokenizedCardData;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This model holds the card data and optional cardholder authentication details.")
public class AuthenticatedCardData
extends TokenizedCardData {
    @JsonProperty(value="cardholderAuthentication")
    protected CardholderAuthentication cardholderAuthentication = null;

    @ApiModelProperty(value="The cardholder authentication information. The authentication is optional and can be provided if the cardholder has been already authenticated (e.g. in 3-D Secure system).")
    public CardholderAuthentication getCardholderAuthentication() {
        return this.cardholderAuthentication;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatedCardData authenticatedCardData = (AuthenticatedCardData)o;
        return Objects.equals(this.cryptogram, authenticatedCardData.cryptogram) && Objects.equals((Object)this.recurringIndicator, (Object)authenticatedCardData.recurringIndicator) && Objects.equals(this.tokenRequestorId, authenticatedCardData.tokenRequestorId) && Objects.equals(this.cardholderAuthentication, authenticatedCardData.cardholderAuthentication) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.cryptogram, this.recurringIndicator, this.tokenRequestorId, this.cardholderAuthentication, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatedCardData {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    cryptogram: ").append(this.toIndentedString(this.cryptogram)).append("\n");
        sb.append("    recurringIndicator: ").append(this.toIndentedString((Object)this.recurringIndicator)).append("\n");
        sb.append("    tokenRequestorId: ").append(this.toIndentedString(this.tokenRequestorId)).append("\n");
        sb.append("    cardholderAuthentication: ").append(this.toIndentedString(this.cardholderAuthentication)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

