/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Meta information about a column within a table.")
public class AnalyticsSchemaColumn {
    @JsonProperty(value="aliasName")
    protected String aliasName = null;
    @JsonProperty(value="columnName")
    protected String columnName = null;
    @JsonProperty(value="description")
    protected Map<String, String> description = null;
    @JsonProperty(value="precision")
    protected Integer precision = null;
    @JsonProperty(value="referencedTable")
    protected String referencedTable = null;
    @JsonProperty(value="scale")
    protected Integer scale = null;
    @JsonProperty(value="tableName")
    protected String tableName = null;
    @JsonProperty(value="type")
    protected String type = null;

    @ApiModelProperty(value="The name of the alias defined for the column in the query or null if none is defined.")
    public String getAliasName() {
        return this.aliasName;
    }

    @ApiModelProperty(value="The name of the column in the table or null if this is a synthetic column which is the result of some SQL expression.")
    public String getColumnName() {
        return this.columnName;
    }

    @ApiModelProperty(value="The localized description of the property contained in this column or null if this is a synthetic column which is the result of some SQL expression.")
    public Map<String, String> getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The precision (maximal number of digits) for decimal data types, otherwise 0.")
    public Integer getPrecision() {
        return this.precision;
    }

    @ApiModelProperty(value="The name of the referenced table if this column represents a foreign-key relation to another table, otherwise null.")
    public String getReferencedTable() {
        return this.referencedTable;
    }

    @ApiModelProperty(value="The scale (maximal number of digits in the fractional part) in case of a decimal data type, otherwise 0.")
    public Integer getScale() {
        return this.scale;
    }

    @ApiModelProperty(value="The name of the table that the column belongs to.")
    public String getTableName() {
        return this.tableName;
    }

    @ApiModelProperty(value="The ORC data type of the column value.")
    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsSchemaColumn analyticsSchemaColumn = (AnalyticsSchemaColumn)o;
        return Objects.equals(this.aliasName, analyticsSchemaColumn.aliasName) && Objects.equals(this.columnName, analyticsSchemaColumn.columnName) && Objects.equals(this.description, analyticsSchemaColumn.description) && Objects.equals(this.precision, analyticsSchemaColumn.precision) && Objects.equals(this.referencedTable, analyticsSchemaColumn.referencedTable) && Objects.equals(this.scale, analyticsSchemaColumn.scale) && Objects.equals(this.tableName, analyticsSchemaColumn.tableName) && Objects.equals(this.type, analyticsSchemaColumn.type);
    }

    public int hashCode() {
        return Objects.hash(this.aliasName, this.columnName, this.description, this.precision, this.referencedTable, this.scale, this.tableName, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsSchemaColumn {\n");
        sb.append("    aliasName: ").append(this.toIndentedString(this.aliasName)).append("\n");
        sb.append("    columnName: ").append(this.toIndentedString(this.columnName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    referencedTable: ").append(this.toIndentedString(this.referencedTable)).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.scale)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

