/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class AnalyticsQuery {
    @JsonProperty(value="accountId")
    protected Long accountId = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="maxCacheAge")
    protected Integer maxCacheAge = null;
    @JsonProperty(value="queryString")
    protected String queryString = null;
    @JsonProperty(value="scannedDataLimit")
    protected BigDecimal scannedDataLimit = null;
    @JsonProperty(value="spaceIds")
    protected List<Long> spaceIds = null;

    public AnalyticsQuery accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account in which the query is to be executed.")
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AnalyticsQuery externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(value="A client-generated nonce which uniquely identifies some action to be executed. Subsequent requests with the same external ID do not execute the action again, but return the original result.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public AnalyticsQuery maxCacheAge(Integer maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
        return this;
    }

    @ApiModelProperty(value="The maximum age (in minutes) of queries already executed that are to be taken into account. If an equivalent query is already available and not older than the specified age, its result will be returned instead of re-executing it. To force a new execution, specify a new, unique external ID and no maximum cache age.")
    public Integer getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public void setMaxCacheAge(Integer maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
    }

    public AnalyticsQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @ApiModelProperty(value="The PrestoDB/Athena SQL statement to be executed.")
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public AnalyticsQuery scannedDataLimit(BigDecimal scannedDataLimit) {
        this.scannedDataLimit = scannedDataLimit;
        return this;
    }

    @ApiModelProperty(value="The maximum amount of data that the query is allowed to scan. After the limit is reached, the query will be canceled.")
    public BigDecimal getScannedDataLimit() {
        return this.scannedDataLimit;
    }

    public void setScannedDataLimit(BigDecimal scannedDataLimit) {
        this.scannedDataLimit = scannedDataLimit;
    }

    public AnalyticsQuery spaceIds(List<Long> spaceIds) {
        this.spaceIds = spaceIds;
        return this;
    }

    public AnalyticsQuery addSpaceIdsItem(Long spaceIdsItem) {
        if (this.spaceIds == null) {
            this.spaceIds = new ArrayList<Long>();
        }
        this.spaceIds.add(spaceIdsItem);
        return this;
    }

    @ApiModelProperty(value="The IDs of the spaces belonging to the specified account in which the query is to be executed. Do not provide any value to query all spaces in the specified account.")
    public List<Long> getSpaceIds() {
        return this.spaceIds;
    }

    public void setSpaceIds(List<Long> spaceIds) {
        this.spaceIds = spaceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsQuery analyticsQuery = (AnalyticsQuery)o;
        return Objects.equals(this.accountId, analyticsQuery.accountId) && Objects.equals(this.externalId, analyticsQuery.externalId) && Objects.equals(this.maxCacheAge, analyticsQuery.maxCacheAge) && Objects.equals(this.queryString, analyticsQuery.queryString) && Objects.equals(this.scannedDataLimit, analyticsQuery.scannedDataLimit) && Objects.equals(this.spaceIds, analyticsQuery.spaceIds);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.externalId, this.maxCacheAge, this.queryString, this.scannedDataLimit, this.spaceIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsQuery {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    maxCacheAge: ").append(this.toIndentedString(this.maxCacheAge)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    scannedDataLimit: ").append(this.toIndentedString(this.scannedDataLimit)).append("\n");
        sb.append("    spaceIds: ").append(this.toIndentedString(this.spaceIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

