/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AddressCreate;
import ch.postfinance.sdk.model.LineItemCreate;
import ch.postfinance.sdk.model.TokenizationMode;
import ch.postfinance.sdk.model.TransactionCompletionBehavior;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AbstractTransactionPending {
    @JsonProperty(value="allowedPaymentMethodBrands")
    protected List<Long> allowedPaymentMethodBrands = null;
    @JsonProperty(value="allowedPaymentMethodConfigurations")
    protected List<Long> allowedPaymentMethodConfigurations = null;
    @JsonProperty(value="billingAddress")
    protected AddressCreate billingAddress = null;
    @JsonProperty(value="completionBehavior")
    protected TransactionCompletionBehavior completionBehavior = null;
    @JsonProperty(value="currency")
    protected String currency = null;
    @JsonProperty(value="customerEmailAddress")
    protected String customerEmailAddress = null;
    @JsonProperty(value="customerId")
    protected String customerId = null;
    @JsonProperty(value="failedUrl")
    protected String failedUrl = null;
    @JsonProperty(value="invoiceMerchantReference")
    protected String invoiceMerchantReference = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItemCreate> lineItems = null;
    @JsonProperty(value="merchantReference")
    protected String merchantReference = null;
    @JsonProperty(value="metaData")
    protected Map<String, String> metaData = null;
    @JsonProperty(value="shippingAddress")
    protected AddressCreate shippingAddress = null;
    @JsonProperty(value="shippingMethod")
    protected String shippingMethod = null;
    @JsonProperty(value="successUrl")
    protected String successUrl = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="token")
    protected Long token = null;
    @JsonProperty(value="tokenizationMode")
    protected TokenizationMode tokenizationMode = null;

    public AbstractTransactionPending allowedPaymentMethodBrands(List<Long> allowedPaymentMethodBrands) {
        this.allowedPaymentMethodBrands = allowedPaymentMethodBrands;
        return this;
    }

    public AbstractTransactionPending addAllowedPaymentMethodBrandsItem(Long allowedPaymentMethodBrandsItem) {
        if (this.allowedPaymentMethodBrands == null) {
            this.allowedPaymentMethodBrands = new ArrayList<Long>();
        }
        this.allowedPaymentMethodBrands.add(allowedPaymentMethodBrandsItem);
        return this;
    }

    @ApiModelProperty(value="The payment method brands that can be used to authorize the transaction.")
    public List<Long> getAllowedPaymentMethodBrands() {
        return this.allowedPaymentMethodBrands;
    }

    public void setAllowedPaymentMethodBrands(List<Long> allowedPaymentMethodBrands) {
        this.allowedPaymentMethodBrands = allowedPaymentMethodBrands;
    }

    public AbstractTransactionPending allowedPaymentMethodConfigurations(List<Long> allowedPaymentMethodConfigurations) {
        this.allowedPaymentMethodConfigurations = allowedPaymentMethodConfigurations;
        return this;
    }

    public AbstractTransactionPending addAllowedPaymentMethodConfigurationsItem(Long allowedPaymentMethodConfigurationsItem) {
        if (this.allowedPaymentMethodConfigurations == null) {
            this.allowedPaymentMethodConfigurations = new ArrayList<Long>();
        }
        this.allowedPaymentMethodConfigurations.add(allowedPaymentMethodConfigurationsItem);
        return this;
    }

    @ApiModelProperty(value="The payment method configurations that can be used to authorize the transaction.")
    public List<Long> getAllowedPaymentMethodConfigurations() {
        return this.allowedPaymentMethodConfigurations;
    }

    public void setAllowedPaymentMethodConfigurations(List<Long> allowedPaymentMethodConfigurations) {
        this.allowedPaymentMethodConfigurations = allowedPaymentMethodConfigurations;
    }

    public AbstractTransactionPending billingAddress(AddressCreate billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="The address associated with the payment method for invoicing and transaction processing purposes.")
    public AddressCreate getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AddressCreate billingAddress) {
        this.billingAddress = billingAddress;
    }

    public AbstractTransactionPending completionBehavior(TransactionCompletionBehavior completionBehavior) {
        this.completionBehavior = completionBehavior;
        return this;
    }

    @ApiModelProperty(value="The behavior that controls when the transaction is completed.")
    public TransactionCompletionBehavior getCompletionBehavior() {
        return this.completionBehavior;
    }

    public void setCompletionBehavior(TransactionCompletionBehavior completionBehavior) {
        this.completionBehavior = completionBehavior;
    }

    public AbstractTransactionPending currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The three-letter code (ISO 4217 format) of the transaction's currency.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public AbstractTransactionPending customerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
        return this;
    }

    @ApiModelProperty(value="The customer's email address.")
    public String getCustomerEmailAddress() {
        return this.customerEmailAddress;
    }

    public void setCustomerEmailAddress(String customerEmailAddress) {
        this.customerEmailAddress = customerEmailAddress;
    }

    public AbstractTransactionPending customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the customer in the external system.")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public AbstractTransactionPending failedUrl(String failedUrl) {
        this.failedUrl = failedUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to redirect the customer back to after they canceled or failed to authenticated their payment.")
    public String getFailedUrl() {
        return this.failedUrl;
    }

    public void setFailedUrl(String failedUrl) {
        this.failedUrl = failedUrl;
    }

    public AbstractTransactionPending invoiceMerchantReference(String invoiceMerchantReference) {
        this.invoiceMerchantReference = invoiceMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The merchant's reference used to identify the invoice.")
    public String getInvoiceMerchantReference() {
        return this.invoiceMerchantReference;
    }

    public void setInvoiceMerchantReference(String invoiceMerchantReference) {
        this.invoiceMerchantReference = invoiceMerchantReference;
    }

    public AbstractTransactionPending language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The language that is linked to the object.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public AbstractTransactionPending lineItems(List<LineItemCreate> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public AbstractTransactionPending addLineItemsItem(LineItemCreate lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItemCreate>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="The line items purchased by the customer.")
    public List<LineItemCreate> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemCreate> lineItems) {
        this.lineItems = lineItems;
    }

    public AbstractTransactionPending merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The merchant's reference used to identify the transaction.")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public AbstractTransactionPending metaData(Map<String, String> metaData) {
        this.metaData = metaData;
        return this;
    }

    public AbstractTransactionPending putMetaDataItem(String key, String metaDataItem) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, String>();
        }
        this.metaData.put(key, metaDataItem);
        return this;
    }

    @ApiModelProperty(value="Allow to store additional information about the object.")
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public AbstractTransactionPending shippingAddress(AddressCreate shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="The address to where the order will be shipped.")
    public AddressCreate getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(AddressCreate shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public AbstractTransactionPending shippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
        return this;
    }

    @ApiModelProperty(value="The name of the shipping method used to ship the products.")
    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public AbstractTransactionPending successUrl(String successUrl) {
        this.successUrl = successUrl;
        return this;
    }

    @ApiModelProperty(value="The URL to redirect the customer back to after they successfully authenticated their payment.")
    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public AbstractTransactionPending timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(value="The customer's time zone, which affects how dates and times are formatted when communicating with the customer.")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public AbstractTransactionPending token(Long token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="The payment token that should be used to charge the customer.")
    public Long getToken() {
        return this.token;
    }

    public void setToken(Long token) {
        this.token = token;
    }

    public AbstractTransactionPending tokenizationMode(TokenizationMode tokenizationMode) {
        this.tokenizationMode = tokenizationMode;
        return this;
    }

    @ApiModelProperty(value="The tokenization mode specifies whether and how the tokenization of payment information is applied to the transaction.")
    public TokenizationMode getTokenizationMode() {
        return this.tokenizationMode;
    }

    public void setTokenizationMode(TokenizationMode tokenizationMode) {
        this.tokenizationMode = tokenizationMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransactionPending abstractTransactionPending = (AbstractTransactionPending)o;
        return Objects.equals(this.allowedPaymentMethodBrands, abstractTransactionPending.allowedPaymentMethodBrands) && Objects.equals(this.allowedPaymentMethodConfigurations, abstractTransactionPending.allowedPaymentMethodConfigurations) && Objects.equals(this.billingAddress, abstractTransactionPending.billingAddress) && Objects.equals((Object)this.completionBehavior, (Object)abstractTransactionPending.completionBehavior) && Objects.equals(this.currency, abstractTransactionPending.currency) && Objects.equals(this.customerEmailAddress, abstractTransactionPending.customerEmailAddress) && Objects.equals(this.customerId, abstractTransactionPending.customerId) && Objects.equals(this.failedUrl, abstractTransactionPending.failedUrl) && Objects.equals(this.invoiceMerchantReference, abstractTransactionPending.invoiceMerchantReference) && Objects.equals(this.language, abstractTransactionPending.language) && Objects.equals(this.lineItems, abstractTransactionPending.lineItems) && Objects.equals(this.merchantReference, abstractTransactionPending.merchantReference) && Objects.equals(this.metaData, abstractTransactionPending.metaData) && Objects.equals(this.shippingAddress, abstractTransactionPending.shippingAddress) && Objects.equals(this.shippingMethod, abstractTransactionPending.shippingMethod) && Objects.equals(this.successUrl, abstractTransactionPending.successUrl) && Objects.equals(this.timeZone, abstractTransactionPending.timeZone) && Objects.equals(this.token, abstractTransactionPending.token) && Objects.equals((Object)this.tokenizationMode, (Object)abstractTransactionPending.tokenizationMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethodBrands, this.allowedPaymentMethodConfigurations, this.billingAddress, this.completionBehavior, this.currency, this.customerEmailAddress, this.customerId, this.failedUrl, this.invoiceMerchantReference, this.language, this.lineItems, this.merchantReference, this.metaData, this.shippingAddress, this.shippingMethod, this.successUrl, this.timeZone, this.token, this.tokenizationMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbstractTransactionPending {\n");
        sb.append("    allowedPaymentMethodBrands: ").append(this.toIndentedString(this.allowedPaymentMethodBrands)).append("\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    completionBehavior: ").append(this.toIndentedString((Object)this.completionBehavior)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    customerEmailAddress: ").append(this.toIndentedString(this.customerEmailAddress)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    failedUrl: ").append(this.toIndentedString(this.failedUrl)).append("\n");
        sb.append("    invoiceMerchantReference: ").append(this.toIndentedString(this.invoiceMerchantReference)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    metaData: ").append(this.toIndentedString(this.metaData)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    shippingMethod: ").append(this.toIndentedString(this.shippingMethod)).append("\n");
        sb.append("    successUrl: ").append(this.toIndentedString(this.successUrl)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenizationMode: ").append(this.toIndentedString((Object)this.tokenizationMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

