/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.LineItemCreate;
import ch.postfinance.sdk.model.PaymentLinkAddressHandlingMode;
import ch.postfinance.sdk.model.PaymentMethodConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AbstractPaymentLinkUpdate {
    @JsonProperty(value="allowedPaymentMethodConfigurations")
    protected List<PaymentMethodConfiguration> allowedPaymentMethodConfigurations = null;
    @JsonProperty(value="appliedSpaceView")
    protected Long appliedSpaceView = null;
    @JsonProperty(value="availableFrom")
    protected OffsetDateTime availableFrom = null;
    @JsonProperty(value="availableUntil")
    protected OffsetDateTime availableUntil = null;
    @JsonProperty(value="billingAddressHandlingMode")
    protected PaymentLinkAddressHandlingMode billingAddressHandlingMode = null;
    @JsonProperty(value="currency")
    protected String currency = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItemCreate> lineItems = null;
    @JsonProperty(value="maximalNumberOfTransactions")
    protected Integer maximalNumberOfTransactions = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="shippingAddressHandlingMode")
    protected PaymentLinkAddressHandlingMode shippingAddressHandlingMode = null;

    public AbstractPaymentLinkUpdate allowedPaymentMethodConfigurations(List<PaymentMethodConfiguration> allowedPaymentMethodConfigurations) {
        this.allowedPaymentMethodConfigurations = allowedPaymentMethodConfigurations;
        return this;
    }

    public AbstractPaymentLinkUpdate addAllowedPaymentMethodConfigurationsItem(PaymentMethodConfiguration allowedPaymentMethodConfigurationsItem) {
        if (this.allowedPaymentMethodConfigurations == null) {
            this.allowedPaymentMethodConfigurations = new ArrayList<PaymentMethodConfiguration>();
        }
        this.allowedPaymentMethodConfigurations.add(allowedPaymentMethodConfigurationsItem);
        return this;
    }

    @ApiModelProperty(value="The allowed payment method configurations restrict the payment methods which can be used with this payment link.")
    public List<PaymentMethodConfiguration> getAllowedPaymentMethodConfigurations() {
        return this.allowedPaymentMethodConfigurations;
    }

    public void setAllowedPaymentMethodConfigurations(List<PaymentMethodConfiguration> allowedPaymentMethodConfigurations) {
        this.allowedPaymentMethodConfigurations = allowedPaymentMethodConfigurations;
    }

    public AbstractPaymentLinkUpdate appliedSpaceView(Long appliedSpaceView) {
        this.appliedSpaceView = appliedSpaceView;
        return this;
    }

    @ApiModelProperty(value="The payment link can be conducted in a specific space view. The space view may apply a specific design to the payment page.")
    public Long getAppliedSpaceView() {
        return this.appliedSpaceView;
    }

    public void setAppliedSpaceView(Long appliedSpaceView) {
        this.appliedSpaceView = appliedSpaceView;
    }

    public AbstractPaymentLinkUpdate availableFrom(OffsetDateTime availableFrom) {
        this.availableFrom = availableFrom;
        return this;
    }

    @ApiModelProperty(value="The available from date defines the earliest date on which the payment link can be used. When no date is specified there will be no restriction.")
    public OffsetDateTime getAvailableFrom() {
        return this.availableFrom;
    }

    public void setAvailableFrom(OffsetDateTime availableFrom) {
        this.availableFrom = availableFrom;
    }

    public AbstractPaymentLinkUpdate availableUntil(OffsetDateTime availableUntil) {
        this.availableUntil = availableUntil;
        return this;
    }

    @ApiModelProperty(value="The available from date defines the latest date on which the payment link can be used to initialize a transaction. When no date is specified there will be no restriction.")
    public OffsetDateTime getAvailableUntil() {
        return this.availableUntil;
    }

    public void setAvailableUntil(OffsetDateTime availableUntil) {
        this.availableUntil = availableUntil;
    }

    public AbstractPaymentLinkUpdate billingAddressHandlingMode(PaymentLinkAddressHandlingMode billingAddressHandlingMode) {
        this.billingAddressHandlingMode = billingAddressHandlingMode;
        return this;
    }

    @ApiModelProperty(value="The billing address handling mode controls if the address is collected or not and how it is collected.")
    public PaymentLinkAddressHandlingMode getBillingAddressHandlingMode() {
        return this.billingAddressHandlingMode;
    }

    public void setBillingAddressHandlingMode(PaymentLinkAddressHandlingMode billingAddressHandlingMode) {
        this.billingAddressHandlingMode = billingAddressHandlingMode;
    }

    public AbstractPaymentLinkUpdate currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The currency defines in which currency the payment is executed in. If no currency is defined it has to be specified within the request parameter 'currency'.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public AbstractPaymentLinkUpdate language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The language defines the language of the payment page. If no language is provided it can be provided through the request parameter.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public AbstractPaymentLinkUpdate lineItems(List<LineItemCreate> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public AbstractPaymentLinkUpdate addLineItemsItem(LineItemCreate lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItemCreate>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="The line items allows to define the line items for this payment link. When the line items are defined they cannot be overridden through the request parameters. If no amount for the payment link is defined, the additional checkout page to enter the amount is shown to the consumer.")
    public List<LineItemCreate> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemCreate> lineItems) {
        this.lineItems = lineItems;
    }

    public AbstractPaymentLinkUpdate maximalNumberOfTransactions(Integer maximalNumberOfTransactions) {
        this.maximalNumberOfTransactions = maximalNumberOfTransactions;
        return this;
    }

    @ApiModelProperty(value="The maximal number of transactions limits the number of transactions which can be created with this payment link.")
    public Integer getMaximalNumberOfTransactions() {
        return this.maximalNumberOfTransactions;
    }

    public void setMaximalNumberOfTransactions(Integer maximalNumberOfTransactions) {
        this.maximalNumberOfTransactions = maximalNumberOfTransactions;
    }

    public AbstractPaymentLinkUpdate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The payment link name is used internally to identify the payment link. For example the name is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractPaymentLinkUpdate shippingAddressHandlingMode(PaymentLinkAddressHandlingMode shippingAddressHandlingMode) {
        this.shippingAddressHandlingMode = shippingAddressHandlingMode;
        return this;
    }

    @ApiModelProperty(value="The shipping address handling mode controls if the address is collected or not and how it is collected.")
    public PaymentLinkAddressHandlingMode getShippingAddressHandlingMode() {
        return this.shippingAddressHandlingMode;
    }

    public void setShippingAddressHandlingMode(PaymentLinkAddressHandlingMode shippingAddressHandlingMode) {
        this.shippingAddressHandlingMode = shippingAddressHandlingMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPaymentLinkUpdate abstractPaymentLinkUpdate = (AbstractPaymentLinkUpdate)o;
        return Objects.equals(this.allowedPaymentMethodConfigurations, abstractPaymentLinkUpdate.allowedPaymentMethodConfigurations) && Objects.equals(this.appliedSpaceView, abstractPaymentLinkUpdate.appliedSpaceView) && Objects.equals(this.availableFrom, abstractPaymentLinkUpdate.availableFrom) && Objects.equals(this.availableUntil, abstractPaymentLinkUpdate.availableUntil) && Objects.equals((Object)this.billingAddressHandlingMode, (Object)abstractPaymentLinkUpdate.billingAddressHandlingMode) && Objects.equals(this.currency, abstractPaymentLinkUpdate.currency) && Objects.equals(this.language, abstractPaymentLinkUpdate.language) && Objects.equals(this.lineItems, abstractPaymentLinkUpdate.lineItems) && Objects.equals(this.maximalNumberOfTransactions, abstractPaymentLinkUpdate.maximalNumberOfTransactions) && Objects.equals(this.name, abstractPaymentLinkUpdate.name) && Objects.equals((Object)this.shippingAddressHandlingMode, (Object)abstractPaymentLinkUpdate.shippingAddressHandlingMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethodConfigurations, this.appliedSpaceView, this.availableFrom, this.availableUntil, this.billingAddressHandlingMode, this.currency, this.language, this.lineItems, this.maximalNumberOfTransactions, this.name, this.shippingAddressHandlingMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbstractPaymentLinkUpdate {\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    appliedSpaceView: ").append(this.toIndentedString(this.appliedSpaceView)).append("\n");
        sb.append("    availableFrom: ").append(this.toIndentedString(this.availableFrom)).append("\n");
        sb.append("    availableUntil: ").append(this.toIndentedString(this.availableUntil)).append("\n");
        sb.append("    billingAddressHandlingMode: ").append(this.toIndentedString((Object)this.billingAddressHandlingMode)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    maximalNumberOfTransactions: ").append(this.toIndentedString(this.maximalNumberOfTransactions)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    shippingAddressHandlingMode: ").append(this.toIndentedString((Object)this.shippingAddressHandlingMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

