/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.CriteriaOperator;
import ch.postfinance.sdk.model.CustomersPresence;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.EntityQueryFilterType;
import ch.postfinance.sdk.model.Token;
import ch.postfinance.sdk.model.TokenUpdate;
import ch.postfinance.sdk.model.TokenizationMode;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionCompletionBehavior;
import ch.postfinance.sdk.model.TransactionCompletionState;
import ch.postfinance.sdk.model.TransactionCreate;
import ch.postfinance.sdk.model.TransactionPending;
import ch.postfinance.sdk.model.TransactionState;
import ch.postfinance.sdk.service.CardProcessingService;
import ch.postfinance.sdk.service.TokenService;
import ch.postfinance.sdk.service.TransactionCompletionService;
import ch.postfinance.sdk.service.TransactionService;
import ch.postfinance.sdk.test.TestConstants;
import ch.postfinance.sdk.test.TestUtils;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionServiceTest {
    private TransactionService transactionService;
    private CardProcessingService cardProcessingService;
    private TokenService tokenService;
    private TransactionCompletionService transactionCompletionService;

    @Before
    public void beforeEach() {
        ApiClient apiClient = TestUtils.getApiClient();
        this.transactionService = apiClient.getTransactionService();
        this.cardProcessingService = apiClient.getCardProcessingService();
        this.tokenService = apiClient.getTokenService();
        this.transactionCompletionService = apiClient.getTransactionCompletionService();
    }

    @Test
    public void createShouldCreateTransactionInPendingState() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Assert.assertEquals((String)"State must be PENDING", (Object)TransactionState.PENDING, (Object)transaction.getState());
    }

    @Test
    public void confirmShouldMakeTransactionConfirmed() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        TransactionPending update = new TransactionPending();
        update.setId(transaction.getId());
        update.setVersion(Long.valueOf(transaction.getVersion().intValue()));
        Transaction confirmedTransaction = this.transactionService.confirm(Long.valueOf(405L), update);
        Assert.assertEquals((String)"State must be CONFIRMED", (Object)TransactionState.CONFIRMED, (Object)confirmedTransaction.getState());
    }

    @Test
    public void deferredTransactionProcessingShouldMakeTransactionAuthorized() throws IOException {
        TransactionCreate transactionCreate = TestUtils.getTransactionCreatePayload();
        transactionCreate.setTokenizationMode(TokenizationMode.FORCE_CREATION);
        transactionCreate.setCustomersPresence(CustomersPresence.NOT_PRESENT);
        transactionCreate.setCompletionBehavior(TransactionCompletionBehavior.COMPLETE_DEFERRED);
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), transactionCreate);
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)processedTransaction.getState());
    }

    @Test
    public void completeImmediatelyTransactionShouldMakeTransactionFulfilled() throws IOException {
        TransactionCreate transactionCreate = TestUtils.getTransactionCreatePayload();
        transactionCreate.setTokenizationMode(TokenizationMode.FORCE_CREATION);
        transactionCreate.setCustomersPresence(CustomersPresence.NOT_PRESENT);
        transactionCreate.setCompletionBehavior(TransactionCompletionBehavior.COMPLETE_IMMEDIATELY);
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), transactionCreate);
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be FULFILL", (Object)TransactionState.FULFILL, (Object)processedTransaction.getState());
    }

    @Test
    public void countByGivenCriteriaShouldReturnTransactionCount() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        EntityQueryFilter criteria = new EntityQueryFilter();
        criteria.setFieldName("id");
        criteria.setValue((Object)transaction.getId());
        criteria.setType(EntityQueryFilterType.LEAF);
        criteria.setOperator(CriteriaOperator.EQUALS);
        long count = this.transactionService.count(Long.valueOf(405L), criteria);
        Assert.assertEquals((String)"Transaction count should be 1", (long)1L, (long)count);
    }

    @Test
    public void fetchPaymentMethodsShouldReturnAvailablePaymentMethods() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        List methods = this.transactionService.fetchPaymentMethods(Long.valueOf(405L), transaction.getId(), "payment_page");
        Assert.assertFalse((String)"Payment methods should be configured for a given transaction in test space", (boolean)methods.isEmpty());
    }

    @Test
    public void createTransactionCredentialsShouldCreateTransactionToken() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        String creds = this.transactionService.createTransactionCredentials(Long.valueOf(405L), transaction.getId());
        Assert.assertTrue((String)"Transaction credentials token should have valid format", (boolean)creds.startsWith(String.valueOf(405L)));
    }

    @Test
    public void readForExistingTransactionShouldReturnTransactionData() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Transaction readTransaction = this.transactionService.read(Long.valueOf(405L), transaction.getId());
        Assert.assertEquals((String)"Transaction ids should match", (Object)transaction.getId(), (Object)readTransaction.getId());
    }

    @Test
    public void readWithCredentialsWithGivenBadCredentialsShouldFail() {
        Assert.assertThrows((String)"Bad token should error response", IOException.class, () -> this.transactionService.readWithCredentials("invalid_token"));
    }

    @Test
    public void readWithCredentialsShouldReturnTransactionData() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        String creds = this.transactionService.createTransactionCredentials(Long.valueOf(405L), transaction.getId());
        Transaction readTransaction = this.transactionService.readWithCredentials(creds);
        Assert.assertEquals((String)"Transaction ids should match", (Object)transaction.getId(), (Object)readTransaction.getId());
    }

    @Test
    public void searchByGivenCriteriaShouldFindTransaction() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        EntityQueryFilter filter = new EntityQueryFilter();
        filter.setFieldName("id");
        filter.setValue((Object)transaction.getId());
        filter.setType(EntityQueryFilterType.LEAF);
        filter.setOperator(CriteriaOperator.EQUALS);
        EntityQuery entityQuery = new EntityQuery();
        entityQuery.setFilter(filter);
        List transactions = this.transactionService.search(Long.valueOf(405L), entityQuery);
        Assert.assertEquals((String)"Should find 1 transaction", (long)1L, (long)transactions.size());
        transactions.forEach(trans -> Assert.assertEquals((String)"Transaction ids should match", (Object)transaction.getId(), (Object)trans.getId()));
    }

    @Test
    public void updateShouldChangeTransactionData() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        TransactionPending update = new TransactionPending();
        update.setId(transaction.getId());
        update.setVersion(Long.valueOf(transaction.getVersion().intValue()));
        update.setLanguage("en-GB");
        Transaction updatedTransaction = this.transactionService.update(Long.valueOf(405L), update);
        Assert.assertEquals((Object)"en-GB", (Object)updatedTransaction.getLanguage());
    }

    @Test
    public void processWithoutUserInteractionShouldProcessTransactionProperly() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Transaction processedTransaction = this.transactionService.processWithoutUserInteraction(Long.valueOf(405L), transaction.getId());
        Assert.assertEquals((String)"Transaction ids mush match", (Object)transaction.getId(), (Object)processedTransaction.getId());
    }

    @Test
    public void fetchOneClickTokenShouldReturnNoTokensIfThoseWereNotCreatedYet() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        String creds = this.transactionService.createTransactionCredentials(Long.valueOf(405L), transaction.getId());
        List tokens = this.transactionService.fetchOneClickTokensWithCredentials(creds);
        Assert.assertTrue((String)"Should be no tokens yet", (boolean)tokens.isEmpty());
    }

    @Test
    public void fetchPaymentMethodsWithCredentialsShouldReturnDefinedPaymentMethods() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        String creds = this.transactionService.createTransactionCredentials(Long.valueOf(405L), transaction.getId());
        List methods = this.transactionService.fetchPaymentMethodsWithCredentials(creds, "payment_page");
        Assert.assertFalse((String)"Should have some payment methods set up", (boolean)methods.isEmpty());
    }

    @Test
    public void processOneClickTokenAndRedirectWithCredentialsShouldReturnPaymentUrl() throws IOException {
        TransactionCreate transactionCreate1 = TestUtils.getTransactionCreatePayload();
        transactionCreate1.setTokenizationMode(TokenizationMode.FORCE_CREATION_WITH_ONE_CLICK_PAYMENT);
        transactionCreate1.setCustomersPresence(CustomersPresence.NOT_PRESENT);
        transactionCreate1.setCompletionBehavior(TransactionCompletionBehavior.COMPLETE_DEFERRED);
        transactionCreate1.setCustomerId(String.valueOf(7311742L));
        Transaction transaction1 = this.transactionService.create(Long.valueOf(405L), transactionCreate1);
        Transaction processedTransaction1 = this.cardProcessingService.process(Long.valueOf(405L), transaction1.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Token token = this.tokenService.createToken(Long.valueOf(405L), processedTransaction1.getId());
        TokenUpdate tokenUpdate = new TokenUpdate();
        tokenUpdate.setId(token.getId());
        tokenUpdate.setVersion(Long.valueOf(token.getVersion().intValue()));
        tokenUpdate.enabledForOneClickPayment(Boolean.valueOf(true));
        Token updatedToken = this.tokenService.update(Long.valueOf(405L), tokenUpdate);
        TransactionCreate transactionCreate2 = TestUtils.getTransactionCreatePayload();
        transactionCreate2.setTokenizationMode(TokenizationMode.FORCE_CREATION_WITH_ONE_CLICK_PAYMENT);
        transactionCreate2.setCustomersPresence(CustomersPresence.NOT_PRESENT);
        transactionCreate2.setCompletionBehavior(TransactionCompletionBehavior.COMPLETE_DEFERRED);
        transactionCreate2.setCustomerId(String.valueOf(7311742L));
        Transaction transaction2 = this.transactionService.create(Long.valueOf(405L), transactionCreate2);
        String creds2 = this.transactionService.createTransactionCredentials(Long.valueOf(405L), transaction2.getId());
        String paymentUrl2 = this.transactionService.processOneClickTokenAndRedirectWithCredentials(creds2, updatedToken.getId());
        Assert.assertTrue((String)"URL must be of a proper format", (boolean)paymentUrl2.contains("securityToken"));
        Transaction readTransaction2 = this.transactionService.read(Long.valueOf(405L), transaction2.getId());
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)readTransaction2.getState());
        TransactionCompletion completedTransaction2 = this.transactionCompletionService.completeOnline(Long.valueOf(405L), transaction2.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)completedTransaction2.getState());
        TransactionCompletion completedTransaction1 = this.transactionCompletionService.completeOnline(Long.valueOf(405L), transaction1.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)completedTransaction1.getState());
        this.tokenService.delete(Long.valueOf(405L), token.getId());
    }
}

