/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.CriteriaOperator;
import ch.postfinance.sdk.model.CustomersPresence;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.EntityQueryFilterType;
import ch.postfinance.sdk.model.TokenizationMode;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionCompletionBehavior;
import ch.postfinance.sdk.model.TransactionCompletionState;
import ch.postfinance.sdk.model.TransactionCreate;
import ch.postfinance.sdk.model.TransactionState;
import ch.postfinance.sdk.service.CardProcessingService;
import ch.postfinance.sdk.service.TransactionCompletionService;
import ch.postfinance.sdk.service.TransactionService;
import ch.postfinance.sdk.test.TestConstants;
import ch.postfinance.sdk.test.TestUtils;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionCompletionServiceTest {
    private TransactionService transactionService;
    private CardProcessingService cardProcessingService;
    private TransactionCompletionService transactionCompletionService;

    @Before
    public void beforeEach() {
        ApiClient apiClient = TestUtils.getApiClient();
        this.transactionService = apiClient.getTransactionService();
        this.cardProcessingService = apiClient.getCardProcessingService();
        this.transactionCompletionService = apiClient.getTransactionCompletionService();
    }

    @Test
    public void completeOfflineShouldMakeTransactionStatusSuccessful() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), this.getDeferredTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)processedTransaction.getState());
        TransactionCompletion transactionCompletion = this.transactionCompletionService.completeOffline(Long.valueOf(405L), processedTransaction.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)transactionCompletion.getState());
    }

    @Test
    public void completeOnlineShouldMakeTransactionStatusSuccessful() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), this.getDeferredTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)processedTransaction.getState());
        TransactionCompletion transactionCompletion = this.transactionCompletionService.completeOnline(Long.valueOf(405L), processedTransaction.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)transactionCompletion.getState());
    }

    @Test
    public void readShouldReturnCompletedTransactionData() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), this.getDeferredTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)processedTransaction.getState());
        TransactionCompletion transactionCompletion = this.transactionCompletionService.completeOnline(Long.valueOf(405L), processedTransaction.getId());
        TransactionCompletion readTransaction = this.transactionCompletionService.read(Long.valueOf(405L), transactionCompletion.getId());
        Assert.assertEquals((String)"Transaction ids must match", (Object)transactionCompletion.getId(), (Object)readTransaction.getId());
    }

    @Test
    public void countByCriteriaShouldReturnAmountOfCompletedTransactions() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), this.getDeferredTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)processedTransaction.getState());
        TransactionCompletion completedTransaction = this.transactionCompletionService.completeOnline(Long.valueOf(405L), processedTransaction.getId());
        EntityQueryFilter criteria = new EntityQueryFilter();
        criteria.setFieldName("id");
        criteria.setValue((Object)completedTransaction.getId());
        criteria.setType(EntityQueryFilterType.LEAF);
        criteria.setOperator(CriteriaOperator.EQUALS);
        long count = this.transactionCompletionService.count(Long.valueOf(405L), criteria);
        Assert.assertEquals((String)"Count of completions should be 1", (long)1L, (long)count);
    }

    @Test
    public void searchByCriteriaShouldReturnTransactionCompletions() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), this.getDeferredTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        Assert.assertEquals((String)"State must be AUTHORIZED", (Object)TransactionState.AUTHORIZED, (Object)processedTransaction.getState());
        TransactionCompletion transactionCompletion = this.transactionCompletionService.completeOnline(Long.valueOf(405L), processedTransaction.getId());
        EntityQueryFilter filter = new EntityQueryFilter();
        filter.setFieldName("id");
        filter.setValue((Object)transactionCompletion.getId());
        filter.setType(EntityQueryFilterType.LEAF);
        filter.setOperator(CriteriaOperator.EQUALS);
        EntityQuery criteria = new EntityQuery();
        criteria.setFilter(filter);
        List completions = this.transactionCompletionService.search(Long.valueOf(405L), criteria);
        Assert.assertFalse((String)"Completions should exist", (boolean)completions.isEmpty());
        completions.forEach(compl -> Assert.assertEquals((String)"Completion id should match", (Object)transactionCompletion.getId(), (Object)compl.getId()));
    }

    private TransactionCreate getDeferredTransactionCreatePayload() {
        TransactionCreate create = TestUtils.getTransactionCreatePayload();
        create.setTokenizationMode(TokenizationMode.FORCE_CREATION);
        create.setCustomersPresence(CustomersPresence.NOT_PRESENT);
        create.setCompletionBehavior(TransactionCompletionBehavior.COMPLETE_DEFERRED);
        return create;
    }
}

