/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.CriteriaOperator;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.EntityQueryFilterType;
import ch.postfinance.sdk.model.Refund;
import ch.postfinance.sdk.model.RefundCreate;
import ch.postfinance.sdk.model.RefundState;
import ch.postfinance.sdk.model.RefundType;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionCompletionState;
import ch.postfinance.sdk.service.CardProcessingService;
import ch.postfinance.sdk.service.RefundService;
import ch.postfinance.sdk.service.TransactionCompletionService;
import ch.postfinance.sdk.service.TransactionService;
import ch.postfinance.sdk.test.TestConstants;
import ch.postfinance.sdk.test.TestUtils;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RefundTest {
    private TransactionService transactionService;
    private CardProcessingService cardProcessingService;
    private TransactionCompletionService transactionCompletionService;
    private RefundService refundService;

    @Before
    public void beforeEach() {
        ApiClient apiClient = TestUtils.getApiClient();
        this.transactionService = apiClient.getTransactionService();
        this.cardProcessingService = apiClient.getCardProcessingService();
        this.transactionCompletionService = apiClient.getTransactionCompletionService();
        this.refundService = apiClient.getRefundService();
    }

    @Test
    public void refundOfCompletedTransactionShouldWork() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        TransactionCompletion completedTransaction = this.transactionCompletionService.completeOffline(Long.valueOf(405L), processedTransaction.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)completedTransaction.getState());
        Transaction readTransaction = this.transactionService.read(Long.valueOf(405L), processedTransaction.getId());
        Refund refund = this.refundService.refund(Long.valueOf(405L), this.getRefundCreatePayload(readTransaction));
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)RefundState.SUCCESSFUL, (Object)refund.getState());
    }

    @Test
    public void readShouldReturnRefundData() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        TransactionCompletion completedTransaction = this.transactionCompletionService.completeOffline(Long.valueOf(405L), processedTransaction.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)completedTransaction.getState());
        Transaction readTransaction = this.transactionService.read(Long.valueOf(405L), processedTransaction.getId());
        Refund refund = this.refundService.refund(Long.valueOf(405L), this.getRefundCreatePayload(readTransaction));
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)RefundState.SUCCESSFUL, (Object)refund.getState());
        Refund readRefund = this.refundService.read(Long.valueOf(405L), refund.getId());
        Assert.assertEquals((String)"Refund ids must match", (Object)refund.getId(), (Object)readRefund.getId());
    }

    @Test
    public void searchByGivenCriteriaShouldReturnRefund() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        TransactionCompletion completedTransaction = this.transactionCompletionService.completeOffline(Long.valueOf(405L), processedTransaction.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)completedTransaction.getState());
        Transaction readTransaction = this.transactionService.read(Long.valueOf(405L), processedTransaction.getId());
        Refund refund = this.refundService.refund(Long.valueOf(405L), this.getRefundCreatePayload(readTransaction));
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)RefundState.SUCCESSFUL, (Object)refund.getState());
        EntityQueryFilter filter = new EntityQueryFilter();
        filter.setFieldName("id");
        filter.setValue((Object)refund.getId());
        filter.setType(EntityQueryFilterType.LEAF);
        filter.setOperator(CriteriaOperator.EQUALS);
        EntityQuery criteria = new EntityQuery();
        criteria.setFilter(filter);
        List refunds = this.refundService.search(Long.valueOf(405L), criteria);
        Assert.assertEquals((String)"Should find 1 refund", (long)1L, (long)refunds.size());
        refunds.forEach(ref -> Assert.assertEquals((String)"Refund ids must match", (Object)refund.getId(), (Object)ref.getId()));
    }

    @Test
    public void countByGivenCriteriaShouldReturnAmountOfRefunds() throws IOException {
        Transaction transaction = this.transactionService.create(Long.valueOf(405L), TestUtils.getTransactionCreatePayload());
        Transaction processedTransaction = this.cardProcessingService.process(Long.valueOf(405L), transaction.getId(), Long.valueOf(1352L), TestConstants.FAKE_CARD_DATA);
        TransactionCompletion completedTransaction = this.transactionCompletionService.completeOffline(Long.valueOf(405L), processedTransaction.getId());
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)TransactionCompletionState.SUCCESSFUL, (Object)completedTransaction.getState());
        Transaction readTransaction = this.transactionService.read(Long.valueOf(405L), processedTransaction.getId());
        Refund refund = this.refundService.refund(Long.valueOf(405L), this.getRefundCreatePayload(readTransaction));
        Assert.assertEquals((String)"State must be SUCCESSFUL", (Object)RefundState.SUCCESSFUL, (Object)refund.getState());
        EntityQueryFilter criteria = new EntityQueryFilter();
        criteria.setFieldName("id");
        criteria.setValue((Object)refund.getId());
        criteria.setType(EntityQueryFilterType.LEAF);
        criteria.setOperator(CriteriaOperator.EQUALS);
        long count = this.refundService.count(Long.valueOf(405L), criteria);
        Assert.assertEquals((long)1L, (long)count);
    }

    private RefundCreate getRefundCreatePayload(Transaction transaction) {
        RefundCreate create = new RefundCreate();
        create.setExternalId(String.valueOf(transaction.getId()));
        create.setType(RefundType.MERCHANT_INITIATED_ONLINE);
        create.setAmount(transaction.getAuthorizationAmount());
        create.setTransaction(transaction.getId());
        create.setMerchantReference(transaction.getMerchantReference());
        return create;
    }
}

