/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.exception.PostFinanceCheckoutSdkException;
import ch.postfinance.sdk.model.WebhookEncryptionPublicKey;
import ch.postfinance.sdk.util.EncryptionUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EncryptionUtilTest {
    private static final String SIGNATURE_ALGORITHM = "SHA256withECDSA";
    private static final String VALID_CONTENT_TO_VERIFY = "{\"entityId\":11,\"eventId\":35,\"listenerEntityId\":1472041829003,\"listenerEntityTechnicalName\":\"Transaction\",\"spaceId\":1,\"state\":\"PROCESSING\",\"timestamp\":\"2023-12-19T13:43:35+0000\",\"webhookListenerId\":2}";
    private static final String VALID_CONTENT_SIGNATURE = "MEYCIQCTzbMrMsOAC6T57T9kQTb1iGZVg2R7n6pY9A4ML4P31gIhAIOoav8cG8x0jpRWQztqSJIC8gXWKq+4DuENEySvmMYf";
    private static final String VALID_ENCODED_PUBLIC_KEY = "MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdWq7ZBGsjUzhBO3e6mzUBLpjpV3TQw1bL1rk3ocjn5C5qne7TY0OBBhiWgaPtWlvUcqASz903vtfeSTQma+SBA==";
    private static WebhookEncryptionPublicKey VALID_PUBLIC_KEY;

    @BeforeClass
    public static void init() {
        EncryptionUtilTest.setupSecurityProvider();
        EncryptionUtilTest.setupValidPublicKeyAsApiObject();
    }

    @Test
    public void validationShouldPassForValidContentSignatureAndKey() {
        boolean validationResult = EncryptionUtil.isContentValid((String)VALID_CONTENT_TO_VERIFY, (String)VALID_CONTENT_SIGNATURE, (WebhookEncryptionPublicKey)VALID_PUBLIC_KEY, (String)"BC", (String)SIGNATURE_ALGORITHM);
        Assert.assertTrue((String)"Valid public key, signature and content must fit each other", (boolean)validationResult);
    }

    @Test
    public void validationShouldFailForBadContent() {
        boolean validationResult = EncryptionUtil.isContentValid((String)"ModifiedContent", (String)VALID_CONTENT_SIGNATURE, (WebhookEncryptionPublicKey)VALID_PUBLIC_KEY, (String)"BC", (String)SIGNATURE_ALGORITHM);
        Assert.assertFalse((String)"Invalid content should fail validation", (boolean)validationResult);
    }

    @Test
    public void validationShouldFailForBadSignatureFormat() {
        Assert.assertThrows((String)"Invalid signature should fail validation", PostFinanceCheckoutSdkException.class, () -> EncryptionUtil.isContentValid((String)VALID_CONTENT_TO_VERIFY, (String)"InvalidModifiedSignature", (WebhookEncryptionPublicKey)VALID_PUBLIC_KEY, (String)"BC", (String)SIGNATURE_ALGORITHM));
    }

    @Test
    public void validationShouldFailForBadSignatureBase64Format() {
        Assert.assertThrows((String)"Invalid signature should fail validation", PostFinanceCheckoutSdkException.class, () -> EncryptionUtil.isContentValid((String)VALID_CONTENT_TO_VERIFY, (String)"MEYCIQCTzbMrMsOAC6T57T9kQTb1iGZVg2R7n6pY9A4ML4P31gIhAIOoav8cG8x0jpRWQztqSJIC8gXWKq", (WebhookEncryptionPublicKey)VALID_PUBLIC_KEY, (String)"BC", (String)SIGNATURE_ALGORITHM));
    }

    @Test
    public void validationShouldFailForBadPublicKeyFormat() {
        Assert.assertThrows((String)"Invalid public key should fail validation", PostFinanceCheckoutSdkException.class, () -> EncryptionUtil.isContentValid((String)VALID_CONTENT_TO_VERIFY, (String)VALID_CONTENT_SIGNATURE, (WebhookEncryptionPublicKey)EncryptionUtilTest.getPublicKeyAsApiObject("InvalidModifiedPublicKey"), (String)"BC", (String)SIGNATURE_ALGORITHM));
    }

    @Test
    public void validationShouldFailForBadPublicKeyBase64Format() {
        Assert.assertThrows((String)"Invalid public key should fail validation", IllegalArgumentException.class, () -> EncryptionUtil.isContentValid((String)VALID_CONTENT_TO_VERIFY, (String)VALID_CONTENT_SIGNATURE, (WebhookEncryptionPublicKey)EncryptionUtilTest.getPublicKeyAsApiObject("MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdWq7ZBGsjUzhBO3e6mzUBLpjpV3TQw1bL1rk3ocjn5C5qne7TY0OBBhiWgaPtWlvUcqASz903vtfeSTQm"), (String)"BC", (String)SIGNATURE_ALGORITHM));
    }

    private static void setupValidPublicKeyAsApiObject() {
        VALID_PUBLIC_KEY = EncryptionUtilTest.getPublicKeyAsApiObject(VALID_ENCODED_PUBLIC_KEY);
    }

    private static WebhookEncryptionPublicKey getPublicKeyAsApiObject(String key) {
        String json = "{\n    \"id\": \"123456890\",\n    \"publicKey\": \"" + key + "\"\n}";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (WebhookEncryptionPublicKey)objectMapper.readValue(json, WebhookEncryptionPublicKey.class);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void setupSecurityProvider() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

