/**
* PostFinance Checkout SDK
*
* This library allows to interact with the PostFinance Checkout payment service.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/


package ch.postfinance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import ch.postfinance.sdk.model.AnalyticsQueryExecution;
import ch.postfinance.sdk.model.AnalyticsSchemaColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.*;
import java.time.OffsetDateTime;

/**
 * A batch of the result of a query executed in Analytics.
 */
@ApiModel(description = "A batch of the result of a query executed in Analytics.")

public class AnalyticsQueryResultBatch {
  
  @JsonProperty("columns")
  protected List<AnalyticsSchemaColumn> columns = null;

  
  @JsonProperty("nextToken")
  protected String nextToken = null;

  
  @JsonProperty("queryExecution")
  protected AnalyticsQueryExecution queryExecution = null;

  
  @JsonProperty("rows")
  protected List<List<String>> rows = null;

  
  
   /**
   * The schemas of the columns returned by the query (in order).
   * @return columns
  **/
  @ApiModelProperty(value = "The schemas of the columns returned by the query (in order).")
  public List<AnalyticsSchemaColumn> getColumns() {
    return columns;
  }

  
   /**
   * The token to fetch the next batch of results. Null if no more results are available.
   * @return nextToken
  **/
  @ApiModelProperty(value = "The token to fetch the next batch of results. Null if no more results are available.")
  public String getNextToken() {
    return nextToken;
  }

  
   /**
   * The query execution that produced the result.
   * @return queryExecution
  **/
  @ApiModelProperty(value = "The query execution that produced the result.")
  public AnalyticsQueryExecution getQueryExecution() {
    return queryExecution;
  }

  
   /**
   * The resulting rows contained in this batch where each row is a list of column values.
   * @return rows
  **/
  @ApiModelProperty(value = "The resulting rows contained in this batch where each row is a list of column values.")
  public List<List<String>> getRows() {
    return rows;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnalyticsQueryResultBatch analyticsQueryResultBatch = (AnalyticsQueryResultBatch) o;
    return Objects.equals(this.columns, analyticsQueryResultBatch.columns) &&
        Objects.equals(this.nextToken, analyticsQueryResultBatch.nextToken) &&
        Objects.equals(this.queryExecution, analyticsQueryResultBatch.queryExecution) &&
        Objects.equals(this.rows, analyticsQueryResultBatch.rows);
  }

  @Override
  public int hashCode() {
    return Objects.hash(columns, nextToken, queryExecution, rows);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnalyticsQueryResultBatch {\n");
    
    sb.append("    columns: ").append(toIndentedString(columns)).append("\n");
    sb.append("    nextToken: ").append(toIndentedString(nextToken)).append("\n");
    sb.append("    queryExecution: ").append(toIndentedString(queryExecution)).append("\n");
    sb.append("    rows: ").append(toIndentedString(rows)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

