/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.AddressCreate;
import ch.postfinance.sdk.model.LineItemCreate;
import ch.postfinance.sdk.model.LineItemType;
import ch.postfinance.sdk.model.Refund;
import ch.postfinance.sdk.model.RefundCreate;
import ch.postfinance.sdk.model.RefundState;
import ch.postfinance.sdk.model.RefundType;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCompletion;
import ch.postfinance.sdk.model.TransactionCompletionState;
import ch.postfinance.sdk.model.TransactionCreate;
import ch.postfinance.sdk.model.TransactionState;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class RefundServiceTest {
    private Long spaceId = 405L;
    private Long applicationUserId = 512L;
    private String authenticationKey = "FKrO76r5VwJtBrqZawBspljbBNOxp5veKQQkOnZxucQ=";
    private ApiClient apiClient;
    private TransactionCreate transactionPayload;

    @Before
    public void setup() {
        if (this.apiClient == null) {
            this.apiClient = new ApiClient(this.applicationUserId.longValue(), this.authenticationKey);
        }
    }

    private TransactionCreate getTransactionPayload() {
        if (this.transactionPayload == null) {
            LineItemCreate lineItem = new LineItemCreate();
            lineItem.name("Red T-Shirt").uniqueId("5412").type(LineItemType.PRODUCT).quantity(BigDecimal.valueOf(1L)).amountIncludingTax(BigDecimal.valueOf(29.95)).sku("red-t-shirt-123");
            AddressCreate billingAddress = new AddressCreate();
            billingAddress.city("Winterthur").country("CH").emailAddress("test@example.com").familyName("Customer").givenName("Good").postcode("8400").postalState("ZH").organizationName("Test GmbH").mobilePhoneNumber("+41791234567").salutation("Ms");
            this.transactionPayload = new TransactionCreate();
            this.transactionPayload.autoConfirmationEnabled(Boolean.valueOf(true)).currency("CHF").language("en-US");
            this.transactionPayload.setBillingAddress(billingAddress);
            this.transactionPayload.setShippingAddress(billingAddress);
            this.transactionPayload.addLineItemsItem(lineItem);
        }
        return this.transactionPayload;
    }

    private RefundCreate getRefundPayload(Transaction transaction) {
        RefundCreate refundPayload = new RefundCreate();
        refundPayload.amount(transaction.getAuthorizationAmount()).transaction(transaction.getId()).merchantReference(transaction.getMerchantReference()).externalId(transaction.getId().toString()).type(RefundType.MERCHANT_INITIATED_ONLINE);
        return refundPayload;
    }

    @Ignore
    @Test
    public void countTest() {
    }

    @Ignore
    @Test
    public void failTest() {
    }

    @Ignore
    @Test
    public void getRefundDocumentTest() {
    }

    @Ignore
    @Test
    public void getRefundDocumentWithTargetMediaTypeTest() {
    }

    @Ignore
    @Test
    public void readTest() {
    }

    @Test
    public void refundTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        transaction = this.apiClient.getTransactionService().processWithoutUserInteraction(this.spaceId, transaction.getId());
        for (int i = 1; i <= 10 && transaction.getState() != TransactionState.FULFILL && transaction.getState() != TransactionState.FAILED; ++i) {
            try {
                Thread.sleep(i * 500);
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            transaction = this.apiClient.getTransactionService().read(this.spaceId, transaction.getId());
        }
        if (transaction.getState() == TransactionState.FULFILL) {
            TransactionCompletion transactionCompletion = this.apiClient.getTransactionCompletionService().completeOffline(this.spaceId, transaction.getId());
            Assert.assertEquals((String)"Transaction completion successful", (Object)transactionCompletion.getState(), (Object)TransactionCompletionState.SUCCESSFUL);
            transaction = this.apiClient.getTransactionService().read(transaction.getLinkedSpaceId(), transactionCompletion.getLinkedTransaction());
            Refund refund = this.apiClient.getRefundService().refund(this.spaceId, this.getRefundPayload(transaction));
            Assert.assertEquals((String)"Refund successful", (Object)refund.getState(), (Object)RefundState.SUCCESSFUL);
        } else {
            System.err.println("API response timeout");
        }
    }

    @Ignore
    @Test
    public void searchTest() {
    }

    @Ignore
    @Test
    public void succeedTest() {
    }
}

