/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.AddressCreate;
import ch.postfinance.sdk.model.LineItemCreate;
import ch.postfinance.sdk.model.LineItemType;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCreate;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionPaymentPageServiceTest {
    private Long spaceId = 405L;
    private Long applicationUserId = 512L;
    private String authenticationKey = "FKrO76r5VwJtBrqZawBspljbBNOxp5veKQQkOnZxucQ=";
    private ApiClient apiClient;
    private TransactionCreate transactionPayload;

    @Before
    public void setup() {
        if (this.apiClient == null) {
            this.apiClient = new ApiClient(this.applicationUserId.longValue(), this.authenticationKey);
        }
    }

    private TransactionCreate getTransactionPayload() {
        if (this.transactionPayload == null) {
            LineItemCreate lineItem = new LineItemCreate();
            lineItem.name("Red T-Shirt").uniqueId("5412").type(LineItemType.PRODUCT).quantity(BigDecimal.valueOf(1L)).amountIncludingTax(BigDecimal.valueOf(29.95)).sku("red-t-shirt-123");
            AddressCreate billingAddress = new AddressCreate();
            billingAddress.city("Winterthur").country("CH").emailAddress("test@example.com").familyName("Customer").givenName("Good").postcode("8400").postalState("ZH").organizationName("Test GmbH").mobilePhoneNumber("+41791234567").salutation("Ms");
            this.transactionPayload = new TransactionCreate();
            this.transactionPayload.autoConfirmationEnabled(Boolean.valueOf(true)).currency("CHF").language("en-US");
            this.transactionPayload.setBillingAddress(billingAddress);
            this.transactionPayload.setShippingAddress(billingAddress);
            this.transactionPayload.addLineItemsItem(lineItem);
        }
        return this.transactionPayload;
    }

    @Test
    public void paymentPageUrlTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        String paymentPageUrl = this.apiClient.getTransactionPaymentPageService().paymentPageUrl(this.spaceId, transaction.getId());
        Assert.assertTrue((boolean)paymentPageUrl.contains("https://"));
    }
}

