/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.test;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.AddressCreate;
import ch.postfinance.sdk.model.CriteriaOperator;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.EntityQueryFilterType;
import ch.postfinance.sdk.model.LineItemCreate;
import ch.postfinance.sdk.model.LineItemType;
import ch.postfinance.sdk.model.RenderedDocument;
import ch.postfinance.sdk.model.Transaction;
import ch.postfinance.sdk.model.TransactionCreate;
import ch.postfinance.sdk.model.TransactionPending;
import ch.postfinance.sdk.model.TransactionState;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TransactionServiceTest {
    private Long spaceId = 405L;
    private Long applicationUserId = 512L;
    private String authenticationKey = "FKrO76r5VwJtBrqZawBspljbBNOxp5veKQQkOnZxucQ=";
    private ApiClient apiClient;
    private TransactionCreate transactionPayload;

    @Before
    public void setup() {
        if (this.apiClient == null) {
            this.apiClient = new ApiClient(this.applicationUserId.longValue(), this.authenticationKey);
        }
    }

    private TransactionCreate getTransactionPayload() {
        if (this.transactionPayload == null) {
            LineItemCreate lineItem = new LineItemCreate();
            lineItem.name("Red T-Shirt").uniqueId("5412").type(LineItemType.PRODUCT).quantity(BigDecimal.valueOf(1L)).amountIncludingTax(BigDecimal.valueOf(29.95)).sku("red-t-shirt-123");
            String customerEmailAddress = "test@example.com";
            AddressCreate billingAddress = new AddressCreate();
            billingAddress.city("Winterthur").country("CH").emailAddress(customerEmailAddress).familyName("Customer").givenName("Good").postcode("8400").postalState("ZH").organizationName("Test GmbH").mobilePhoneNumber("+41791234567").salutation("Ms");
            this.transactionPayload = new TransactionCreate();
            this.transactionPayload.autoConfirmationEnabled(Boolean.valueOf(true)).currency("CHF").language("en-US");
            this.transactionPayload.setBillingAddress(billingAddress);
            this.transactionPayload.setShippingAddress(billingAddress);
            this.transactionPayload.addLineItemsItem(lineItem);
            this.transactionPayload.setCustomerId("1234");
            this.transactionPayload.setCustomerEmailAddress(customerEmailAddress);
        }
        return this.transactionPayload;
    }

    @Ignore
    @Test
    public void confirmTest() {
    }

    @Test
    public void countTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        EntityQueryFilter filter = new EntityQueryFilter();
        filter.type(EntityQueryFilterType.LEAF).fieldName("id").value((Object)transaction.getId()).operator(CriteriaOperator.EQUALS);
        Long count = this.apiClient.getTransactionService().count(this.spaceId, filter);
        Assert.assertEquals((long)count, (long)1L);
    }

    @Test
    public void createTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        Assert.assertEquals((Object)transaction.getState(), (Object)TransactionState.PENDING);
    }

    @Test
    public void createTransactionCredentialsTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        String transactionCredentials = this.apiClient.getTransactionService().createTransactionCredentials(this.spaceId, transaction.getId());
        Assert.assertTrue((!transactionCredentials.isEmpty() ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void deleteOneClickTokenWithCredentialsTest() {
    }

    @Ignore
    @Test
    public void exportTest() {
    }

    @Ignore
    @Test
    public void fetchOneClickTokensWithCredentialsTest() {
    }

    @Test
    public void fetchPaymentMethodsTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        List paymentMethods = this.apiClient.getTransactionService().fetchPaymentMethods(this.spaceId, transaction.getId(), "payment_page");
        Assert.assertTrue((paymentMethods.size() >= 1 ? 1 : 0) != 0);
    }

    @Ignore
    @Test
    public void fetchPaymentMethodsWithCredentialsTest() {
    }

    @Ignore
    @Test
    public void getLatestTransactionLineItemVersionTest() {
    }

    @Ignore
    @Test
    public void getPackingSlipTest() {
    }

    @Ignore
    @Test
    public void processOneClickTokenAndRedirectWithCredentialsTest() {
    }

    @Test
    public void processWithoutUserInteractionTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        transaction = this.apiClient.getTransactionService().processWithoutUserInteraction(this.spaceId, transaction.getId());
        for (int i = 1; i <= 10 && transaction.getState() != TransactionState.FULFILL && transaction.getState() != TransactionState.FAILED; ++i) {
            try {
                Thread.sleep(i * 500);
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            transaction = this.apiClient.getTransactionService().read(this.spaceId, transaction.getId());
        }
        TransactionState[] TransactionStates = new TransactionState[]{TransactionState.FULFILL};
        if (transaction.getState() == TransactionState.FULFILL) {
            Assert.assertTrue((boolean)Arrays.asList(TransactionStates).contains(transaction.getState()));
            RenderedDocument renderedDocument = this.apiClient.getTransactionService().getInvoiceDocument(this.spaceId, transaction.getId());
            Assert.assertEquals((Object)true, (Object)(renderedDocument.getData() != null ? 1 : 0));
            Assert.assertEquals((Object)true, (Object)(renderedDocument.getData().length > 0 ? 1 : 0));
        } else {
            System.err.println("API response timeout");
        }
    }

    @Test
    public void readTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        Transaction transactionRead = this.apiClient.getTransactionService().read(this.spaceId, transaction.getId());
        Assert.assertTrue((boolean)transaction.getId().equals(transactionRead.getId()));
    }

    @Ignore
    @Test
    public void readWithCredentialsTest() {
    }

    @Test
    public void searchTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        EntityQueryFilter entityQueryFilter = new EntityQueryFilter();
        entityQueryFilter.fieldName("id").value((Object)transaction.getId()).type(EntityQueryFilterType.LEAF).operator(CriteriaOperator.EQUALS);
        EntityQuery entityQuery = new EntityQuery();
        entityQuery.setFilter(entityQueryFilter);
        List transactionSearch = this.apiClient.getTransactionService().search(this.spaceId, entityQuery);
        Assert.assertEquals((long)transactionSearch.size(), (long)1L);
        for (Transaction t : transactionSearch) {
            Assert.assertEquals((Object)t.getState(), (Object)TransactionState.PENDING);
        }
    }

    @Test
    public void updateTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        TransactionPending transactionPending = new TransactionPending();
        transactionPending.id(transaction.getId()).language("en-US");
        transactionPending.version(Long.valueOf(transaction.getVersion().longValue()));
        transactionPending.setCurrency(transaction.getCurrency());
        Transaction transactionUpdate = this.apiClient.getTransactionService().update(this.spaceId, transactionPending);
        Assert.assertEquals((Object)transaction.getId(), (Object)transactionUpdate.getId());
    }

    @Test
    public void updateTransactionLineItemsTest() throws Exception {
        Transaction transaction = this.apiClient.getTransactionService().create(this.spaceId, this.getTransactionPayload());
        LineItemCreate lineItem = new LineItemCreate();
        lineItem.name("Blue T-Shirt").uniqueId("5413").type(LineItemType.PRODUCT).quantity(BigDecimal.valueOf(1L)).amountIncludingTax(BigDecimal.valueOf(39.95)).sku("blue-t-shirt-123");
        TransactionPending transactionPending = new TransactionPending();
        transactionPending.version(Long.valueOf(transaction.getVersion().longValue())).id(transaction.getId()).addLineItemsItem(lineItem).customerId(transaction.getCustomerId()).currency(transaction.getCurrency());
        Transaction transactionUpdate = this.apiClient.getTransactionService().update(this.spaceId, transactionPending);
        Assert.assertEquals((Object)transaction.getId(), (Object)transactionUpdate.getId());
    }
}

