/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.RestAddressFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class RestCountry {
    @JsonProperty(value="ISOCode2Letter")
    protected String isOCode2Letter = null;
    @JsonProperty(value="ISOCode3Letter")
    protected String isOCode3Letter = null;
    @JsonProperty(value="addressFormat")
    protected RestAddressFormat addressFormat = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="numericCode")
    protected String numericCode = null;
    @JsonProperty(value="stateCodes")
    protected List<String> stateCodes = null;

    @ApiModelProperty(value="The ISO code 2 letter identifies the country by two chars as defined in ISO 3166-1 (e.g. US, DE, CH).")
    public String getIsOCode2Letter() {
        return this.isOCode2Letter;
    }

    @ApiModelProperty(value="The ISO code 3 letter identifies the country by three chars as defined in ISO 3166-1 (e.g. CHE, USA, GBR).")
    public String getIsOCode3Letter() {
        return this.isOCode3Letter;
    }

    @ApiModelProperty(value="The address format of the country indicates how an address has to look like for the country.")
    public RestAddressFormat getAddressFormat() {
        return this.addressFormat;
    }

    @ApiModelProperty(value="The name labels the country by a name in English.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="The numeric code identifies the country by a three digit number as defined in ISO 3166-1 (e.g. 840, 826, 756).")
    public String getNumericCode() {
        return this.numericCode;
    }

    @ApiModelProperty(value="The state codes field is a list of all states associated with this country. The list contains the identifiers of the states. The identifiers corresponds to the ISO 3166-2 subdivision identifier.")
    public List<String> getStateCodes() {
        return this.stateCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestCountry restCountry = (RestCountry)o;
        return Objects.equals(this.isOCode2Letter, restCountry.isOCode2Letter) && Objects.equals(this.isOCode3Letter, restCountry.isOCode3Letter) && Objects.equals(this.addressFormat, restCountry.addressFormat) && Objects.equals(this.name, restCountry.name) && Objects.equals(this.numericCode, restCountry.numericCode) && Objects.equals(this.stateCodes, restCountry.stateCodes);
    }

    public int hashCode() {
        return Objects.hash(this.isOCode2Letter, this.isOCode3Letter, this.addressFormat, this.name, this.numericCode, this.stateCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestCountry {\n");
        sb.append("    isOCode2Letter: ").append(this.toIndentedString(this.isOCode2Letter)).append("\n");
        sb.append("    isOCode3Letter: ").append(this.toIndentedString(this.isOCode3Letter)).append("\n");
        sb.append("    addressFormat: ").append(this.toIndentedString(this.addressFormat)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numericCode: ").append(this.toIndentedString(this.numericCode)).append("\n");
        sb.append("    stateCodes: ").append(this.toIndentedString(this.stateCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

