/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.AbstractPaymentLinkUpdate;
import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.PaymentLinkProtectionMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The payment link defines an URL to automatically create transactions.")
public class PaymentLinkCreate
extends AbstractPaymentLinkUpdate {
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="protectionMode")
    protected PaymentLinkProtectionMode protectionMode = null;

    public PaymentLinkCreate state(CreationEntityState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    public void setState(CreationEntityState state) {
        this.state = state;
    }

    public PaymentLinkCreate externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(required=true, value="A client generated nonce which identifies the entity to be created. Subsequent creation requests with the same external ID will not create new entities but return the initially created entity instead.")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public PaymentLinkCreate protectionMode(PaymentLinkProtectionMode protectionMode) {
        this.protectionMode = protectionMode;
        return this;
    }

    @ApiModelProperty(value="The protection mode determines if the payment link is protected against tampering and in what way.")
    public PaymentLinkProtectionMode getProtectionMode() {
        return this.protectionMode;
    }

    public void setProtectionMode(PaymentLinkProtectionMode protectionMode) {
        this.protectionMode = protectionMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentLinkCreate paymentLinkCreate = (PaymentLinkCreate)o;
        return Objects.equals(this.allowedPaymentMethodConfigurations, paymentLinkCreate.allowedPaymentMethodConfigurations) && Objects.equals(this.appliedSpaceView, paymentLinkCreate.appliedSpaceView) && Objects.equals(this.availableFrom, paymentLinkCreate.availableFrom) && Objects.equals(this.availableUntil, paymentLinkCreate.availableUntil) && Objects.equals((Object)this.billingAddressHandlingMode, (Object)paymentLinkCreate.billingAddressHandlingMode) && Objects.equals(this.currency, paymentLinkCreate.currency) && Objects.equals(this.language, paymentLinkCreate.language) && Objects.equals(this.lineItems, paymentLinkCreate.lineItems) && Objects.equals(this.maximalNumberOfTransactions, paymentLinkCreate.maximalNumberOfTransactions) && Objects.equals(this.name, paymentLinkCreate.name) && Objects.equals((Object)this.shippingAddressHandlingMode, (Object)paymentLinkCreate.shippingAddressHandlingMode) && Objects.equals((Object)this.state, (Object)paymentLinkCreate.state) && Objects.equals(this.externalId, paymentLinkCreate.externalId) && Objects.equals((Object)this.protectionMode, (Object)paymentLinkCreate.protectionMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethodConfigurations, this.appliedSpaceView, this.availableFrom, this.availableUntil, this.billingAddressHandlingMode, this.currency, this.language, this.lineItems, this.maximalNumberOfTransactions, this.name, this.shippingAddressHandlingMode, this.state, this.externalId, this.protectionMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentLinkCreate {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    appliedSpaceView: ").append(this.toIndentedString(this.appliedSpaceView)).append("\n");
        sb.append("    availableFrom: ").append(this.toIndentedString(this.availableFrom)).append("\n");
        sb.append("    availableUntil: ").append(this.toIndentedString(this.availableUntil)).append("\n");
        sb.append("    billingAddressHandlingMode: ").append(this.toIndentedString((Object)this.billingAddressHandlingMode)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    maximalNumberOfTransactions: ").append(this.toIndentedString(this.maximalNumberOfTransactions)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    shippingAddressHandlingMode: ").append(this.toIndentedString((Object)this.shippingAddressHandlingMode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    protectionMode: ").append(this.toIndentedString((Object)this.protectionMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

