/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.PaymentMethodConfiguration;
import ch.postfinance.sdk.model.PaymentProcessorConfiguration;
import ch.postfinance.sdk.model.SalesChannel;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class PaymentConnectorConfiguration {
    @JsonProperty(value="applicableForTransactionProcessing")
    protected Boolean applicableForTransactionProcessing = null;
    @JsonProperty(value="conditions")
    protected List<Long> conditions = null;
    @JsonProperty(value="connector")
    protected Long connector = null;
    @JsonProperty(value="enabledSalesChannels")
    protected List<SalesChannel> enabledSalesChannels = null;
    @JsonProperty(value="enabledSpaceViews")
    protected List<Long> enabledSpaceViews = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="paymentMethodConfiguration")
    protected PaymentMethodConfiguration paymentMethodConfiguration = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="priority")
    protected Integer priority = null;
    @JsonProperty(value="processorConfiguration")
    protected PaymentProcessorConfiguration processorConfiguration = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="This property indicates if the connector is currently used for processing transactions. In case either the payment method configuration or the processor configuration is not active the connector will not be used even though the connector state is active.")
    public Boolean isApplicableForTransactionProcessing() {
        return this.applicableForTransactionProcessing;
    }

    @ApiModelProperty(value="If a transaction meet all selected conditions the connector configuration will be used to process the transaction otherwise the next connector configuration in line will be chosen according to the priorities.")
    public List<Long> getConditions() {
        return this.conditions;
    }

    @ApiModelProperty(value="")
    public Long getConnector() {
        return this.connector;
    }

    @ApiModelProperty(value="Defines the sales channels the connector configuration is enabled for. In case the set is empty, the connector configuration is enabled for all sales channels.")
    public List<SalesChannel> getEnabledSalesChannels() {
        return this.enabledSalesChannels;
    }

    @ApiModelProperty(value="The connector configuration is only enabled for the selected space views. In case the set is empty the connector configuration is enabled for all space views.")
    public List<Long> getEnabledSpaceViews() {
        return this.enabledSpaceViews;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The connector configuration name is used internally to identify the configuration in administrative interfaces. For example it is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="")
    public PaymentMethodConfiguration getPaymentMethodConfiguration() {
        return this.paymentMethodConfiguration;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The priority will define the order of choice of the connector configurations. The lower the value, the higher the priority is going to be. This value can also be a negative number in case you are adding a new configuration that you want to have a high priority and you dont want to change the priority of all the other configurations.")
    public Integer getPriority() {
        return this.priority;
    }

    @ApiModelProperty(value="")
    public PaymentProcessorConfiguration getProcessorConfiguration() {
        return this.processorConfiguration;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentConnectorConfiguration paymentConnectorConfiguration = (PaymentConnectorConfiguration)o;
        return Objects.equals(this.applicableForTransactionProcessing, paymentConnectorConfiguration.applicableForTransactionProcessing) && Objects.equals(this.conditions, paymentConnectorConfiguration.conditions) && Objects.equals(this.connector, paymentConnectorConfiguration.connector) && Objects.equals(this.enabledSalesChannels, paymentConnectorConfiguration.enabledSalesChannels) && Objects.equals(this.enabledSpaceViews, paymentConnectorConfiguration.enabledSpaceViews) && Objects.equals(this.id, paymentConnectorConfiguration.id) && Objects.equals(this.linkedSpaceId, paymentConnectorConfiguration.linkedSpaceId) && Objects.equals(this.name, paymentConnectorConfiguration.name) && Objects.equals(this.paymentMethodConfiguration, paymentConnectorConfiguration.paymentMethodConfiguration) && Objects.equals(this.plannedPurgeDate, paymentConnectorConfiguration.plannedPurgeDate) && Objects.equals(this.priority, paymentConnectorConfiguration.priority) && Objects.equals(this.processorConfiguration, paymentConnectorConfiguration.processorConfiguration) && Objects.equals((Object)this.state, (Object)paymentConnectorConfiguration.state) && Objects.equals(this.version, paymentConnectorConfiguration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.applicableForTransactionProcessing, this.conditions, this.connector, this.enabledSalesChannels, this.enabledSpaceViews, this.id, this.linkedSpaceId, this.name, this.paymentMethodConfiguration, this.plannedPurgeDate, this.priority, this.processorConfiguration, this.state, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentConnectorConfiguration {\n");
        sb.append("    applicableForTransactionProcessing: ").append(this.toIndentedString(this.applicableForTransactionProcessing)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    connector: ").append(this.toIndentedString(this.connector)).append("\n");
        sb.append("    enabledSalesChannels: ").append(this.toIndentedString(this.enabledSalesChannels)).append("\n");
        sb.append("    enabledSpaceViews: ").append(this.toIndentedString(this.enabledSpaceViews)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    paymentMethodConfiguration: ").append(this.toIndentedString(this.paymentMethodConfiguration)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    processorConfiguration: ").append(this.toIndentedString(this.processorConfiguration)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

