/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.EntityQueryOrderBy;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The entity query allows to search for specific entities by providing filters. This is similar to a SQL query.")
public class EntityQuery {
    @JsonProperty(value="filter")
    protected EntityQueryFilter filter = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="numberOfEntities")
    protected Integer numberOfEntities = null;
    @JsonProperty(value="orderBys")
    protected List<EntityQueryOrderBy> orderBys = null;
    @JsonProperty(value="startingEntity")
    protected Integer startingEntity = null;

    public EntityQuery filter(EntityQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(value="The filter node defines the root filter node of the query. The root node may contain multiple sub nodes with different filters in it.")
    public EntityQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(EntityQueryFilter filter) {
        this.filter = filter;
    }

    public EntityQuery language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The language is applied to the ordering of the entities returned. Some entity fields are language dependent and hence the language is required to order them.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public EntityQuery numberOfEntities(Integer numberOfEntities) {
        this.numberOfEntities = numberOfEntities;
        return this;
    }

    @ApiModelProperty(value="The number of entities defines how many entities should be returned. There is a maximum of 100 entities.")
    public Integer getNumberOfEntities() {
        return this.numberOfEntities;
    }

    public void setNumberOfEntities(Integer numberOfEntities) {
        this.numberOfEntities = numberOfEntities;
    }

    public EntityQuery orderBys(List<EntityQueryOrderBy> orderBys) {
        this.orderBys = orderBys;
        return this;
    }

    public EntityQuery addOrderBysItem(EntityQueryOrderBy orderBysItem) {
        if (this.orderBys == null) {
            this.orderBys = new ArrayList<EntityQueryOrderBy>();
        }
        this.orderBys.add(orderBysItem);
        return this;
    }

    @ApiModelProperty(value="The order bys allows to define the ordering of the entities returned by the search.")
    public List<EntityQueryOrderBy> getOrderBys() {
        return this.orderBys;
    }

    public void setOrderBys(List<EntityQueryOrderBy> orderBys) {
        this.orderBys = orderBys;
    }

    public EntityQuery startingEntity(Integer startingEntity) {
        this.startingEntity = startingEntity;
        return this;
    }

    @ApiModelProperty(value="The 'starting entity' defines the entity number at which the returned result should start. The entity number is the consecutive number of the entity as returned and it is not the entity id.")
    public Integer getStartingEntity() {
        return this.startingEntity;
    }

    public void setStartingEntity(Integer startingEntity) {
        this.startingEntity = startingEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityQuery entityQuery = (EntityQuery)o;
        return Objects.equals(this.filter, entityQuery.filter) && Objects.equals(this.language, entityQuery.language) && Objects.equals(this.numberOfEntities, entityQuery.numberOfEntities) && Objects.equals(this.orderBys, entityQuery.orderBys) && Objects.equals(this.startingEntity, entityQuery.startingEntity);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.language, this.numberOfEntities, this.orderBys, this.startingEntity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityQuery {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    numberOfEntities: ").append(this.toIndentedString(this.numberOfEntities)).append("\n");
        sb.append("    orderBys: ").append(this.toIndentedString(this.orderBys)).append("\n");
        sb.append("    startingEntity: ").append(this.toIndentedString(this.startingEntity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

