/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.ClientErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An error that is returned as the result of a bad user request or a misconfiguration.")
public class ClientError {
    @JsonProperty(value="date")
    protected String date = null;
    @JsonProperty(value="defaultMessage")
    protected String defaultMessage = null;
    @JsonProperty(value="id")
    protected String id = null;
    @JsonProperty(value="message")
    protected String message = null;
    @JsonProperty(value="type")
    protected ClientErrorType type = null;

    @ApiModelProperty(value="Date when an error has occurred.")
    public String getDate() {
        return this.date;
    }

    @ApiModelProperty(value="The error message which is translated into the default language (i.e. English).")
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @ApiModelProperty(value="Unique identifier of an error.")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(value="The error message which is translated in into the language of the client.")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(value="The type of the client error.")
    public ClientErrorType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientError clientError = (ClientError)o;
        return Objects.equals(this.date, clientError.date) && Objects.equals(this.defaultMessage, clientError.defaultMessage) && Objects.equals(this.id, clientError.id) && Objects.equals(this.message, clientError.message) && Objects.equals((Object)this.type, (Object)clientError.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.defaultMessage, this.id, this.message, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClientError {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    defaultMessage: ").append(this.toIndentedString(this.defaultMessage)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

