/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Charge;
import ch.postfinance.sdk.model.ChargeAttemptEnvironment;
import ch.postfinance.sdk.model.ChargeAttemptState;
import ch.postfinance.sdk.model.ConnectorInvocation;
import ch.postfinance.sdk.model.CustomersPresence;
import ch.postfinance.sdk.model.FailureReason;
import ch.postfinance.sdk.model.Label;
import ch.postfinance.sdk.model.PaymentConnectorConfiguration;
import ch.postfinance.sdk.model.PaymentTerminal;
import ch.postfinance.sdk.model.TokenVersion;
import ch.postfinance.sdk.model.TransactionAwareEntity;
import ch.postfinance.sdk.model.TransactionCompletionBehavior;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class ChargeAttempt
extends TransactionAwareEntity {
    @JsonProperty(value="charge")
    protected Charge charge = null;
    @JsonProperty(value="completionBehavior")
    protected TransactionCompletionBehavior completionBehavior = null;
    @JsonProperty(value="connectorConfiguration")
    protected PaymentConnectorConfiguration connectorConfiguration = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="customersPresence")
    protected CustomersPresence customersPresence = null;
    @JsonProperty(value="environment")
    protected ChargeAttemptEnvironment environment = null;
    @JsonProperty(value="failedOn")
    protected OffsetDateTime failedOn = null;
    @JsonProperty(value="failureReason")
    protected FailureReason failureReason = null;
    @JsonProperty(value="initializingTokenVersion")
    protected Boolean initializingTokenVersion = null;
    @JsonProperty(value="invocation")
    protected ConnectorInvocation invocation = null;
    @JsonProperty(value="labels")
    protected List<Label> labels = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="nextUpdateOn")
    protected OffsetDateTime nextUpdateOn = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="redirectionUrl")
    protected String redirectionUrl = null;
    @JsonProperty(value="salesChannel")
    protected Long salesChannel = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="state")
    protected ChargeAttemptState state = null;
    @JsonProperty(value="succeededOn")
    protected OffsetDateTime succeededOn = null;
    @JsonProperty(value="terminal")
    protected PaymentTerminal terminal = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="timeoutOn")
    protected OffsetDateTime timeoutOn = null;
    @JsonProperty(value="tokenVersion")
    protected TokenVersion tokenVersion = null;
    @JsonProperty(value="userFailureMessage")
    protected String userFailureMessage = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="")
    public Charge getCharge() {
        return this.charge;
    }

    @ApiModelProperty(value="")
    public TransactionCompletionBehavior getCompletionBehavior() {
        return this.completionBehavior;
    }

    @ApiModelProperty(value="")
    public PaymentConnectorConfiguration getConnectorConfiguration() {
        return this.connectorConfiguration;
    }

    @ApiModelProperty(value="The created on date indicates the date on which the entity was stored into the database.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The customers presence indicates which kind of customer interaction was used during the charge attempt.")
    public CustomersPresence getCustomersPresence() {
        return this.customersPresence;
    }

    @ApiModelProperty(value="")
    public ChargeAttemptEnvironment getEnvironment() {
        return this.environment;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFailedOn() {
        return this.failedOn;
    }

    @ApiModelProperty(value="")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(value="")
    public Boolean isInitializingTokenVersion() {
        return this.initializingTokenVersion;
    }

    @ApiModelProperty(value="")
    public ConnectorInvocation getInvocation() {
        return this.invocation;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    @ApiModelProperty(value="")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getNextUpdateOn() {
        return this.nextUpdateOn;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public String getRedirectionUrl() {
        return this.redirectionUrl;
    }

    @ApiModelProperty(value="")
    public Long getSalesChannel() {
        return this.salesChannel;
    }

    @ApiModelProperty(value="")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="")
    public ChargeAttemptState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getSucceededOn() {
        return this.succeededOn;
    }

    @ApiModelProperty(value="")
    public PaymentTerminal getTerminal() {
        return this.terminal;
    }

    @ApiModelProperty(value="")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getTimeoutOn() {
        return this.timeoutOn;
    }

    @ApiModelProperty(value="")
    public TokenVersion getTokenVersion() {
        return this.tokenVersion;
    }

    @ApiModelProperty(value="The user failure message contains the message for the user in case the attempt failed. The message is localized into the language specified on the transaction.")
    public String getUserFailureMessage() {
        return this.userFailureMessage;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeAttempt chargeAttempt = (ChargeAttempt)o;
        return Objects.equals(this.id, chargeAttempt.id) && Objects.equals(this.linkedSpaceId, chargeAttempt.linkedSpaceId) && Objects.equals(this.linkedTransaction, chargeAttempt.linkedTransaction) && Objects.equals(this.charge, chargeAttempt.charge) && Objects.equals((Object)this.completionBehavior, (Object)chargeAttempt.completionBehavior) && Objects.equals(this.connectorConfiguration, chargeAttempt.connectorConfiguration) && Objects.equals(this.createdOn, chargeAttempt.createdOn) && Objects.equals((Object)this.customersPresence, (Object)chargeAttempt.customersPresence) && Objects.equals((Object)this.environment, (Object)chargeAttempt.environment) && Objects.equals(this.failedOn, chargeAttempt.failedOn) && Objects.equals(this.failureReason, chargeAttempt.failureReason) && Objects.equals(this.initializingTokenVersion, chargeAttempt.initializingTokenVersion) && Objects.equals(this.invocation, chargeAttempt.invocation) && Objects.equals(this.labels, chargeAttempt.labels) && Objects.equals(this.language, chargeAttempt.language) && Objects.equals(this.nextUpdateOn, chargeAttempt.nextUpdateOn) && Objects.equals(this.plannedPurgeDate, chargeAttempt.plannedPurgeDate) && Objects.equals(this.redirectionUrl, chargeAttempt.redirectionUrl) && Objects.equals(this.salesChannel, chargeAttempt.salesChannel) && Objects.equals(this.spaceViewId, chargeAttempt.spaceViewId) && Objects.equals((Object)this.state, (Object)chargeAttempt.state) && Objects.equals(this.succeededOn, chargeAttempt.succeededOn) && Objects.equals(this.terminal, chargeAttempt.terminal) && Objects.equals(this.timeZone, chargeAttempt.timeZone) && Objects.equals(this.timeoutOn, chargeAttempt.timeoutOn) && Objects.equals(this.tokenVersion, chargeAttempt.tokenVersion) && Objects.equals(this.userFailureMessage, chargeAttempt.userFailureMessage) && Objects.equals(this.version, chargeAttempt.version) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.linkedSpaceId, this.linkedTransaction, this.charge, this.completionBehavior, this.connectorConfiguration, this.createdOn, this.customersPresence, this.environment, this.failedOn, this.failureReason, this.initializingTokenVersion, this.invocation, this.labels, this.language, this.nextUpdateOn, this.plannedPurgeDate, this.redirectionUrl, this.salesChannel, this.spaceViewId, this.state, this.succeededOn, this.terminal, this.timeZone, this.timeoutOn, this.tokenVersion, this.userFailureMessage, this.version, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeAttempt {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    linkedTransaction: ").append(this.toIndentedString(this.linkedTransaction)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    completionBehavior: ").append(this.toIndentedString((Object)this.completionBehavior)).append("\n");
        sb.append("    connectorConfiguration: ").append(this.toIndentedString(this.connectorConfiguration)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    customersPresence: ").append(this.toIndentedString((Object)this.customersPresence)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    failedOn: ").append(this.toIndentedString(this.failedOn)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    initializingTokenVersion: ").append(this.toIndentedString(this.initializingTokenVersion)).append("\n");
        sb.append("    invocation: ").append(this.toIndentedString(this.invocation)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    nextUpdateOn: ").append(this.toIndentedString(this.nextUpdateOn)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    redirectionUrl: ").append(this.toIndentedString(this.redirectionUrl)).append("\n");
        sb.append("    salesChannel: ").append(this.toIndentedString(this.salesChannel)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    succeededOn: ").append(this.toIndentedString(this.succeededOn)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    timeoutOn: ").append(this.toIndentedString(this.timeoutOn)).append("\n");
        sb.append("    tokenVersion: ").append(this.toIndentedString(this.tokenVersion)).append("\n");
        sb.append("    userFailureMessage: ").append(this.toIndentedString(this.userFailureMessage)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

