/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.BankTransactionFlowDirection;
import ch.postfinance.sdk.model.BankTransactionState;
import ch.postfinance.sdk.model.CurrencyBankAccount;
import ch.postfinance.sdk.model.PaymentAdjustment;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class BankTransaction {
    @JsonProperty(value="adjustments")
    protected List<PaymentAdjustment> adjustments = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="currencyBankAccount")
    protected CurrencyBankAccount currencyBankAccount = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="flowDirection")
    protected BankTransactionFlowDirection flowDirection = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="postingAmount")
    protected BigDecimal postingAmount = null;
    @JsonProperty(value="reference")
    protected String reference = null;
    @JsonProperty(value="source")
    protected Long source = null;
    @JsonProperty(value="state")
    protected BankTransactionState state = null;
    @JsonProperty(value="totalAdjustmentAmountIncludingTax")
    protected BigDecimal totalAdjustmentAmountIncludingTax = null;
    @JsonProperty(value="type")
    protected Long type = null;
    @JsonProperty(value="valueAmount")
    protected BigDecimal valueAmount = null;
    @JsonProperty(value="valueDate")
    protected OffsetDateTime valueDate = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The adjustments applied on this bank transaction.")
    public List<PaymentAdjustment> getAdjustments() {
        return this.adjustments;
    }

    @ApiModelProperty(value="The created by indicates the user which has created the bank transaction.")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The created on date indicates the date on which the entity was stored into the database.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The currency bank account which is used to handle money flow.")
    public CurrencyBankAccount getCurrencyBankAccount() {
        return this.currencyBankAccount;
    }

    @ApiModelProperty(value="")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="")
    public BankTransactionFlowDirection getFlowDirection() {
        return this.flowDirection;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The posting amount indicates the amount including adjustments.")
    public BigDecimal getPostingAmount() {
        return this.postingAmount;
    }

    @ApiModelProperty(value="")
    public String getReference() {
        return this.reference;
    }

    @ApiModelProperty(value="")
    public Long getSource() {
        return this.source;
    }

    @ApiModelProperty(value="")
    public BankTransactionState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public BigDecimal getTotalAdjustmentAmountIncludingTax() {
        return this.totalAdjustmentAmountIncludingTax;
    }

    @ApiModelProperty(value="")
    public Long getType() {
        return this.type;
    }

    @ApiModelProperty(value="")
    public BigDecimal getValueAmount() {
        return this.valueAmount;
    }

    @ApiModelProperty(value="The value date describes the date the amount is effective on the account.")
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransaction bankTransaction = (BankTransaction)o;
        return Objects.equals(this.adjustments, bankTransaction.adjustments) && Objects.equals(this.createdBy, bankTransaction.createdBy) && Objects.equals(this.createdOn, bankTransaction.createdOn) && Objects.equals(this.currencyBankAccount, bankTransaction.currencyBankAccount) && Objects.equals(this.externalId, bankTransaction.externalId) && Objects.equals((Object)this.flowDirection, (Object)bankTransaction.flowDirection) && Objects.equals(this.id, bankTransaction.id) && Objects.equals(this.linkedSpaceId, bankTransaction.linkedSpaceId) && Objects.equals(this.plannedPurgeDate, bankTransaction.plannedPurgeDate) && Objects.equals(this.postingAmount, bankTransaction.postingAmount) && Objects.equals(this.reference, bankTransaction.reference) && Objects.equals(this.source, bankTransaction.source) && Objects.equals((Object)this.state, (Object)bankTransaction.state) && Objects.equals(this.totalAdjustmentAmountIncludingTax, bankTransaction.totalAdjustmentAmountIncludingTax) && Objects.equals(this.type, bankTransaction.type) && Objects.equals(this.valueAmount, bankTransaction.valueAmount) && Objects.equals(this.valueDate, bankTransaction.valueDate) && Objects.equals(this.version, bankTransaction.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.adjustments, this.createdBy, this.createdOn, this.currencyBankAccount, this.externalId, this.flowDirection, this.id, this.linkedSpaceId, this.plannedPurgeDate, this.postingAmount, this.reference, this.source, this.state, this.totalAdjustmentAmountIncludingTax, this.type, this.valueAmount, this.valueDate, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransaction {\n");
        sb.append("    adjustments: ").append(this.toIndentedString(this.adjustments)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    currencyBankAccount: ").append(this.toIndentedString(this.currencyBankAccount)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    flowDirection: ").append(this.toIndentedString((Object)this.flowDirection)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    postingAmount: ").append(this.toIndentedString(this.postingAmount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    totalAdjustmentAmountIncludingTax: ").append(this.toIndentedString(this.totalAdjustmentAmountIncludingTax)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    valueAmount: ").append(this.toIndentedString(this.valueAmount)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

