/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.service;

import ch.postfinance.sdk.ApiClient;
import ch.postfinance.sdk.model.EntityQuery;
import ch.postfinance.sdk.model.EntityQueryFilter;
import ch.postfinance.sdk.model.InvoiceReconciliationRecord;
import ch.postfinance.sdk.model.TransactionInvoice;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.InputStreamContent;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class InvoiceReconciliationRecordService {
    private ApiClient apiClient;

    public InvoiceReconciliationRecordService(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Long count(Long spaceId, EntityQueryFilter filter) throws IOException {
        HttpResponse response = this.countForHttpResponse(spaceId, filter);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public Long count(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        HttpResponse response = this.countForHttpResponse(filter, spaceId, params);
        String returnType = "Long";
        if (returnType.equals("String")) {
            return (Long)((Object)response.parseAsString());
        }
        TypeReference<Long> typeRef = new TypeReference<Long>(){};
        return (Long)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse countForHttpResponse(Long spaceId, EntityQueryFilter filter) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/count"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(Long spaceId, InputStream filter, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/count"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (filter == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, filter);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse countForHttpResponse(EntityQueryFilter filter, Long spaceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling count");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/count"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, filter);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void discard(Long spaceId, Long id) throws IOException {
        this.discardForHttpResponse(spaceId, id);
    }

    public void discard(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        this.discardForHttpResponse(spaceId, id, params);
    }

    public HttpResponse discardForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling discard");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling discard");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/discard"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse discardForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling discard");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling discard");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/discard"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void linkTransaction(Long spaceId, Long id, Long invoiceId, BigDecimal amount) throws IOException {
        this.linkTransactionForHttpResponse(spaceId, id, invoiceId, amount);
    }

    public void linkTransaction(Long spaceId, Long id, Long invoiceId, Map<String, Object> params) throws IOException {
        this.linkTransactionForHttpResponse(spaceId, id, invoiceId, params);
    }

    public HttpResponse linkTransactionForHttpResponse(Long spaceId, Long id, Long invoiceId, BigDecimal amount) throws IOException {
        Number value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling linkTransaction");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling linkTransaction");
        }
        if (invoiceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceId' when calling linkTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/link-transaction"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (invoiceId != null) {
            key = "invoiceId";
            value = invoiceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (amount != null) {
            key = "amount";
            value = amount;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse linkTransactionForHttpResponse(Long spaceId, Long id, Long invoiceId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling linkTransaction");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling linkTransaction");
        }
        if (invoiceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'invoiceId' when calling linkTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/link-transaction"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        allParams.put("invoiceId", invoiceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public InvoiceReconciliationRecord read(Long spaceId, Long id) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id);
        String returnType = "InvoiceReconciliationRecord";
        if (returnType.equals("String")) {
            return (InvoiceReconciliationRecord)((Object)response.parseAsString());
        }
        TypeReference<InvoiceReconciliationRecord> typeRef = new TypeReference<InvoiceReconciliationRecord>(){};
        return (InvoiceReconciliationRecord)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public InvoiceReconciliationRecord read(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        HttpResponse response = this.readForHttpResponse(spaceId, id, params);
        String returnType = "InvoiceReconciliationRecord";
        if (returnType.equals("String")) {
            return (InvoiceReconciliationRecord)((Object)response.parseAsString());
        }
        TypeReference<InvoiceReconciliationRecord> typeRef = new TypeReference<InvoiceReconciliationRecord>(){};
        return (InvoiceReconciliationRecord)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/read"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse readForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling read");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling read");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/read"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        HttpContent content = null;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("GET", genericUrl, content);
        httpRequest.getHeaders().setContentType("*/*");
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void resolve(Long spaceId, Long id) throws IOException {
        this.resolveForHttpResponse(spaceId, id);
    }

    public void resolve(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        this.resolveForHttpResponse(spaceId, id, params);
    }

    public HttpResponse resolveForHttpResponse(Long spaceId, Long id) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling resolve");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling resolve");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/resolve"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse resolveForHttpResponse(Long spaceId, Long id, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling resolve");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling resolve");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/resolve"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public List<InvoiceReconciliationRecord> search(Long spaceId, EntityQuery query) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query);
        String returnType = "List&lt;InvoiceReconciliationRecord&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<InvoiceReconciliationRecord>> typeRef = new TypeReference<List<InvoiceReconciliationRecord>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<InvoiceReconciliationRecord> search(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        HttpResponse response = this.searchForHttpResponse(spaceId, query, params);
        String returnType = "List&lt;InvoiceReconciliationRecord&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<InvoiceReconciliationRecord>> typeRef = new TypeReference<List<InvoiceReconciliationRecord>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/search"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, InputStream query, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/search"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (query == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, query);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForHttpResponse(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling search");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling search");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/search"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public List<TransactionInvoice> searchForInvoicesByQuery(Long spaceId, EntityQuery query) throws IOException {
        HttpResponse response = this.searchForInvoicesByQueryForHttpResponse(spaceId, query);
        String returnType = "List&lt;TransactionInvoice&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<TransactionInvoice>> typeRef = new TypeReference<List<TransactionInvoice>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public List<TransactionInvoice> searchForInvoicesByQuery(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        HttpResponse response = this.searchForInvoicesByQueryForHttpResponse(spaceId, query, params);
        String returnType = "List&lt;TransactionInvoice&gt;";
        if (returnType.equals("String")) {
            return (List)((Object)response.parseAsString());
        }
        TypeReference<List<TransactionInvoice>> typeRef = new TypeReference<List<TransactionInvoice>>(){};
        return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
    }

    public HttpResponse searchForInvoicesByQueryForHttpResponse(Long spaceId, EntityQuery query) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling searchForInvoicesByQuery");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling searchForInvoicesByQuery");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/search-for-invoices-by-query"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForInvoicesByQueryForHttpResponse(Long spaceId, InputStream query, String mediaType) throws IOException {
        ApiClient.JacksonJsonHttpContent jacksonJsonHttpContent;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling searchForInvoicesByQuery");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling searchForInvoicesByQuery");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/search-for-invoices-by-query"));
        if (spaceId != null) {
            String key = "spaceId";
            Long value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (query == null) {
            ApiClient apiClient = this.apiClient;
            apiClient.getClass();
            jacksonJsonHttpContent = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        } else {
            jacksonJsonHttpContent = new InputStreamContent(mediaType == null ? "application/json; charset=UTF-8" : mediaType, query);
        }
        ApiClient.JacksonJsonHttpContent content = jacksonJsonHttpContent;
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse searchForInvoicesByQueryForHttpResponse(Long spaceId, EntityQuery query, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling searchForInvoicesByQuery");
        }
        if (query == null) {
            throw new IllegalArgumentException("Missing the required parameter 'query' when calling searchForInvoicesByQuery");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/search-for-invoices-by-query"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, query);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public void unlinkTransaction(Long spaceId, Long id, Long linkedCompletionId) throws IOException {
        this.unlinkTransactionForHttpResponse(spaceId, id, linkedCompletionId);
    }

    public void unlinkTransaction(Long spaceId, Long id, Long linkedCompletionId, Map<String, Object> params) throws IOException {
        this.unlinkTransactionForHttpResponse(spaceId, id, linkedCompletionId, params);
    }

    public HttpResponse unlinkTransactionForHttpResponse(Long spaceId, Long id, Long linkedCompletionId) throws IOException {
        Long value;
        String key;
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling unlinkTransaction");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling unlinkTransaction");
        }
        if (linkedCompletionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedCompletionId' when calling unlinkTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/unlink-transaction"));
        if (spaceId != null) {
            key = "spaceId";
            value = spaceId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (id != null) {
            key = "id";
            value = id;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        if (linkedCompletionId != null) {
            key = "linkedCompletionId";
            value = linkedCompletionId;
            uriBuilder = value instanceof Collection ? uriBuilder.queryParam(key, ((Collection)((Object)value)).toArray()) : (value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value}));
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }

    public HttpResponse unlinkTransactionForHttpResponse(Long spaceId, Long id, Long linkedCompletionId, Map<String, Object> params) throws IOException {
        if (spaceId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'spaceId' when calling unlinkTransaction");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling unlinkTransaction");
        }
        if (linkedCompletionId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'linkedCompletionId' when calling unlinkTransaction");
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/invoice-reconciliation-record-service/unlink-transaction"));
        HashMap<String, Long> allParams = params == null ? new HashMap<String, Long>() : new HashMap<String, Object>(params);
        allParams.put("spaceId", spaceId);
        allParams.put("id", id);
        allParams.put("linkedCompletionId", linkedCompletionId);
        for (Map.Entry entryMap : allParams.entrySet()) {
            String key = (String)entryMap.getKey();
            Object value = entryMap.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Collection) {
                uriBuilder = uriBuilder.queryParam(key, ((Collection)value).toArray());
                continue;
            }
            if (value instanceof Object[]) {
                uriBuilder = uriBuilder.queryParam(key, (Object[])value);
                continue;
            }
            uriBuilder = uriBuilder.queryParam(key, new Object[]{value});
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        ApiClient.JacksonJsonHttpContent content = new ApiClient.JacksonJsonHttpContent(apiClient, null);
        HttpRequest httpRequest = this.apiClient.getHttpRequestFactory().buildRequest("POST", genericUrl, (HttpContent)content);
        httpRequest.setReadTimeout(20000);
        return httpRequest.execute();
    }
}

