/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.FailureReason;
import ch.postfinance.sdk.model.Label;
import ch.postfinance.sdk.model.LineItem;
import ch.postfinance.sdk.model.TransactionAwareEntity;
import ch.postfinance.sdk.model.TransactionCompletionMode;
import ch.postfinance.sdk.model.TransactionCompletionState;
import ch.postfinance.sdk.model.TransactionLineItemVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class TransactionCompletion
extends TransactionAwareEntity {
    @JsonProperty(value="amount")
    protected BigDecimal amount = null;
    @JsonProperty(value="baseLineItems")
    protected List<LineItem> baseLineItems = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="externalId")
    protected String externalId = null;
    @JsonProperty(value="failedOn")
    protected OffsetDateTime failedOn = null;
    @JsonProperty(value="failureReason")
    protected FailureReason failureReason = null;
    @JsonProperty(value="invoiceMerchantReference")
    protected String invoiceMerchantReference = null;
    @JsonProperty(value="labels")
    protected List<Label> labels = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lastCompletion")
    protected Boolean lastCompletion = null;
    @JsonProperty(value="lineItemVersion")
    protected TransactionLineItemVersion lineItemVersion = null;
    @JsonProperty(value="lineItems")
    protected List<LineItem> lineItems = null;
    @JsonProperty(value="mode")
    protected TransactionCompletionMode mode = null;
    @JsonProperty(value="nextUpdateOn")
    protected OffsetDateTime nextUpdateOn = null;
    @JsonProperty(value="paymentInformation")
    protected String paymentInformation = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="processingOn")
    protected OffsetDateTime processingOn = null;
    @JsonProperty(value="processorReference")
    protected String processorReference = null;
    @JsonProperty(value="remainingLineItems")
    protected List<LineItem> remainingLineItems = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="state")
    protected TransactionCompletionState state = null;
    @JsonProperty(value="succeededOn")
    protected OffsetDateTime succeededOn = null;
    @JsonProperty(value="taxAmount")
    protected BigDecimal taxAmount = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="timeoutOn")
    protected OffsetDateTime timeoutOn = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The amount which is captured. The amount represents sum of line items including taxes.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @ApiModelProperty(value="The base line items on which the completion is applied on.")
    public List<LineItem> getBaseLineItems() {
        return this.baseLineItems;
    }

    @ApiModelProperty(value="")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The created on date indicates the date on which the entity was stored into the database.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="The external ID helps to identify the entity and a subsequent creation of an entity with the same ID will not create a new entity.")
    public String getExternalId() {
        return this.externalId;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFailedOn() {
        return this.failedOn;
    }

    @ApiModelProperty(value="")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(value="")
    public String getInvoiceMerchantReference() {
        return this.invoiceMerchantReference;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    @ApiModelProperty(value="")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="Indicates if this is the last completion. After the last completion is created the transaction cannot be completed anymore.")
    public Boolean isLastCompletion() {
        return this.lastCompletion;
    }

    @ApiModelProperty(value="")
    public TransactionLineItemVersion getLineItemVersion() {
        return this.lineItemVersion;
    }

    @ApiModelProperty(value="The line items which are captured.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @ApiModelProperty(value="")
    public TransactionCompletionMode getMode() {
        return this.mode;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getNextUpdateOn() {
        return this.nextUpdateOn;
    }

    @ApiModelProperty(value="")
    public String getPaymentInformation() {
        return this.paymentInformation;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getProcessingOn() {
        return this.processingOn;
    }

    @ApiModelProperty(value="")
    public String getProcessorReference() {
        return this.processorReference;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getRemainingLineItems() {
        return this.remainingLineItems;
    }

    @ApiModelProperty(value="")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="")
    public TransactionCompletionState getState() {
        return this.state;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getSucceededOn() {
        return this.succeededOn;
    }

    @ApiModelProperty(value="The total sum of all taxes of line items.")
    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    @ApiModelProperty(value="")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getTimeoutOn() {
        return this.timeoutOn;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionCompletion transactionCompletion = (TransactionCompletion)o;
        return Objects.equals(this.id, transactionCompletion.id) && Objects.equals(this.linkedSpaceId, transactionCompletion.linkedSpaceId) && Objects.equals(this.linkedTransaction, transactionCompletion.linkedTransaction) && Objects.equals(this.amount, transactionCompletion.amount) && Objects.equals(this.baseLineItems, transactionCompletion.baseLineItems) && Objects.equals(this.createdBy, transactionCompletion.createdBy) && Objects.equals(this.createdOn, transactionCompletion.createdOn) && Objects.equals(this.externalId, transactionCompletion.externalId) && Objects.equals(this.failedOn, transactionCompletion.failedOn) && Objects.equals(this.failureReason, transactionCompletion.failureReason) && Objects.equals(this.invoiceMerchantReference, transactionCompletion.invoiceMerchantReference) && Objects.equals(this.labels, transactionCompletion.labels) && Objects.equals(this.language, transactionCompletion.language) && Objects.equals(this.lastCompletion, transactionCompletion.lastCompletion) && Objects.equals(this.lineItemVersion, transactionCompletion.lineItemVersion) && Objects.equals(this.lineItems, transactionCompletion.lineItems) && Objects.equals((Object)this.mode, (Object)transactionCompletion.mode) && Objects.equals(this.nextUpdateOn, transactionCompletion.nextUpdateOn) && Objects.equals(this.paymentInformation, transactionCompletion.paymentInformation) && Objects.equals(this.plannedPurgeDate, transactionCompletion.plannedPurgeDate) && Objects.equals(this.processingOn, transactionCompletion.processingOn) && Objects.equals(this.processorReference, transactionCompletion.processorReference) && Objects.equals(this.remainingLineItems, transactionCompletion.remainingLineItems) && Objects.equals(this.spaceViewId, transactionCompletion.spaceViewId) && Objects.equals((Object)this.state, (Object)transactionCompletion.state) && Objects.equals(this.succeededOn, transactionCompletion.succeededOn) && Objects.equals(this.taxAmount, transactionCompletion.taxAmount) && Objects.equals(this.timeZone, transactionCompletion.timeZone) && Objects.equals(this.timeoutOn, transactionCompletion.timeoutOn) && Objects.equals(this.version, transactionCompletion.version) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.linkedSpaceId, this.linkedTransaction, this.amount, this.baseLineItems, this.createdBy, this.createdOn, this.externalId, this.failedOn, this.failureReason, this.invoiceMerchantReference, this.labels, this.language, this.lastCompletion, this.lineItemVersion, this.lineItems, this.mode, this.nextUpdateOn, this.paymentInformation, this.plannedPurgeDate, this.processingOn, this.processorReference, this.remainingLineItems, this.spaceViewId, this.state, this.succeededOn, this.taxAmount, this.timeZone, this.timeoutOn, this.version, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionCompletion {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    linkedTransaction: ").append(this.toIndentedString(this.linkedTransaction)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    baseLineItems: ").append(this.toIndentedString(this.baseLineItems)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    failedOn: ").append(this.toIndentedString(this.failedOn)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    invoiceMerchantReference: ").append(this.toIndentedString(this.invoiceMerchantReference)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lastCompletion: ").append(this.toIndentedString(this.lastCompletion)).append("\n");
        sb.append("    lineItemVersion: ").append(this.toIndentedString(this.lineItemVersion)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    nextUpdateOn: ").append(this.toIndentedString(this.nextUpdateOn)).append("\n");
        sb.append("    paymentInformation: ").append(this.toIndentedString(this.paymentInformation)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    processingOn: ").append(this.toIndentedString(this.processingOn)).append("\n");
        sb.append("    processorReference: ").append(this.toIndentedString(this.processorReference)).append("\n");
        sb.append("    remainingLineItems: ").append(this.toIndentedString(this.remainingLineItems)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    succeededOn: ").append(this.toIndentedString(this.succeededOn)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    timeoutOn: ").append(this.toIndentedString(this.timeoutOn)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

