/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Address;
import ch.postfinance.sdk.model.ChargeAttemptEnvironment;
import ch.postfinance.sdk.model.CustomersPresence;
import ch.postfinance.sdk.model.Environment;
import ch.postfinance.sdk.model.FailureReason;
import ch.postfinance.sdk.model.LineItem;
import ch.postfinance.sdk.model.PaymentConnectorConfiguration;
import ch.postfinance.sdk.model.PaymentMethodBrand;
import ch.postfinance.sdk.model.PaymentTerminal;
import ch.postfinance.sdk.model.Token;
import ch.postfinance.sdk.model.TokenizationMode;
import ch.postfinance.sdk.model.TransactionCompletionBehavior;
import ch.postfinance.sdk.model.TransactionEnvironmentSelectionStrategy;
import ch.postfinance.sdk.model.TransactionGroup;
import ch.postfinance.sdk.model.TransactionState;
import ch.postfinance.sdk.model.TransactionUserInterfaceType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="")
public class Transaction {
    @JsonProperty(value="acceptHeader")
    protected String acceptHeader = null;
    @JsonProperty(value="acceptLanguageHeader")
    protected String acceptLanguageHeader = null;
    @JsonProperty(value="allowedPaymentMethodBrands")
    protected List<PaymentMethodBrand> allowedPaymentMethodBrands = null;
    @JsonProperty(value="allowedPaymentMethodConfigurations")
    protected List<Long> allowedPaymentMethodConfigurations = null;
    @JsonProperty(value="authorizationAmount")
    protected BigDecimal authorizationAmount = null;
    @JsonProperty(value="authorizationEnvironment")
    protected ChargeAttemptEnvironment authorizationEnvironment = null;
    @JsonProperty(value="authorizationSalesChannel")
    protected Long authorizationSalesChannel = null;
    @JsonProperty(value="authorizationTimeoutOn")
    protected OffsetDateTime authorizationTimeoutOn = null;
    @JsonProperty(value="authorizedOn")
    protected OffsetDateTime authorizedOn = null;
    @JsonProperty(value="autoConfirmationEnabled")
    protected Boolean autoConfirmationEnabled = null;
    @JsonProperty(value="billingAddress")
    protected Address billingAddress = null;
    @JsonProperty(value="chargeRetryEnabled")
    protected Boolean chargeRetryEnabled = null;
    @JsonProperty(value="completedAmount")
    protected BigDecimal completedAmount = null;
    @JsonProperty(value="completedOn")
    protected OffsetDateTime completedOn = null;
    @JsonProperty(value="completionBehavior")
    protected TransactionCompletionBehavior completionBehavior = null;
    @JsonProperty(value="completionTimeoutOn")
    protected OffsetDateTime completionTimeoutOn = null;
    @JsonProperty(value="confirmedBy")
    protected Long confirmedBy = null;
    @JsonProperty(value="confirmedOn")
    protected OffsetDateTime confirmedOn = null;
    @JsonProperty(value="createdBy")
    protected Long createdBy = null;
    @JsonProperty(value="createdOn")
    protected OffsetDateTime createdOn = null;
    @JsonProperty(value="currency")
    protected String currency = null;
    @JsonProperty(value="customerEmailAddress")
    protected String customerEmailAddress = null;
    @JsonProperty(value="customerId")
    protected String customerId = null;
    @JsonProperty(value="customersPresence")
    protected CustomersPresence customersPresence = null;
    @JsonProperty(value="deliveryDecisionMadeOn")
    protected OffsetDateTime deliveryDecisionMadeOn = null;
    @JsonProperty(value="deviceSessionIdentifier")
    protected String deviceSessionIdentifier = null;
    @JsonProperty(value="emailsDisabled")
    protected Boolean emailsDisabled = null;
    @JsonProperty(value="endOfLife")
    protected OffsetDateTime endOfLife = null;
    @JsonProperty(value="environment")
    protected Environment environment = null;
    @JsonProperty(value="environmentSelectionStrategy")
    protected TransactionEnvironmentSelectionStrategy environmentSelectionStrategy = null;
    @JsonProperty(value="failedOn")
    protected OffsetDateTime failedOn = null;
    @JsonProperty(value="failedUrl")
    protected String failedUrl = null;
    @JsonProperty(value="failureReason")
    protected FailureReason failureReason = null;
    @JsonProperty(value="group")
    protected TransactionGroup group = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="internetProtocolAddress")
    protected String internetProtocolAddress = null;
    @JsonProperty(value="internetProtocolAddressCountry")
    protected String internetProtocolAddressCountry = null;
    @JsonProperty(value="invoiceMerchantReference")
    protected String invoiceMerchantReference = null;
    @JsonProperty(value="javaEnabled")
    protected Boolean javaEnabled = null;
    @JsonProperty(value="language")
    protected String language = null;
    @JsonProperty(value="lineItems")
    protected List<LineItem> lineItems = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="merchantReference")
    protected String merchantReference = null;
    @JsonProperty(value="metaData")
    protected Map<String, String> metaData = null;
    @JsonProperty(value="parent")
    protected Long parent = null;
    @JsonProperty(value="paymentConnectorConfiguration")
    protected PaymentConnectorConfiguration paymentConnectorConfiguration = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="processingOn")
    protected OffsetDateTime processingOn = null;
    @JsonProperty(value="refundedAmount")
    protected BigDecimal refundedAmount = null;
    @JsonProperty(value="screenColorDepth")
    protected String screenColorDepth = null;
    @JsonProperty(value="screenHeight")
    protected String screenHeight = null;
    @JsonProperty(value="screenWidth")
    protected String screenWidth = null;
    @JsonProperty(value="shippingAddress")
    protected Address shippingAddress = null;
    @JsonProperty(value="shippingMethod")
    protected String shippingMethod = null;
    @JsonProperty(value="spaceViewId")
    protected Long spaceViewId = null;
    @JsonProperty(value="state")
    protected TransactionState state = null;
    @JsonProperty(value="successUrl")
    protected String successUrl = null;
    @JsonProperty(value="terminal")
    protected PaymentTerminal terminal = null;
    @JsonProperty(value="timeZone")
    protected String timeZone = null;
    @JsonProperty(value="token")
    protected Token token = null;
    @JsonProperty(value="tokenizationMode")
    protected TokenizationMode tokenizationMode = null;
    @JsonProperty(value="totalAppliedFees")
    protected BigDecimal totalAppliedFees = null;
    @JsonProperty(value="totalSettledAmount")
    protected BigDecimal totalSettledAmount = null;
    @JsonProperty(value="userAgentHeader")
    protected String userAgentHeader = null;
    @JsonProperty(value="userFailureMessage")
    protected String userFailureMessage = null;
    @JsonProperty(value="userInterfaceType")
    protected TransactionUserInterfaceType userInterfaceType = null;
    @JsonProperty(value="version")
    protected Integer version = null;
    @JsonProperty(value="windowHeight")
    protected String windowHeight = null;
    @JsonProperty(value="windowWidth")
    protected String windowWidth = null;
    @JsonProperty(value="yearsToKeep")
    protected Integer yearsToKeep = null;

    @ApiModelProperty(value="")
    public String getAcceptHeader() {
        return this.acceptHeader;
    }

    @ApiModelProperty(value="The accept language contains the header which indicates the language preferences of the buyer.")
    public String getAcceptLanguageHeader() {
        return this.acceptLanguageHeader;
    }

    @ApiModelProperty(value="")
    public List<PaymentMethodBrand> getAllowedPaymentMethodBrands() {
        return this.allowedPaymentMethodBrands;
    }

    @ApiModelProperty(value="")
    public List<Long> getAllowedPaymentMethodConfigurations() {
        return this.allowedPaymentMethodConfigurations;
    }

    @ApiModelProperty(value="")
    public BigDecimal getAuthorizationAmount() {
        return this.authorizationAmount;
    }

    @ApiModelProperty(value="The environment in which this transaction was successfully authorized.")
    public ChargeAttemptEnvironment getAuthorizationEnvironment() {
        return this.authorizationEnvironment;
    }

    @ApiModelProperty(value="The sales channel through which the transaction was placed.")
    public Long getAuthorizationSalesChannel() {
        return this.authorizationSalesChannel;
    }

    @ApiModelProperty(value="This is the time on which the transaction will be timed out when it is not at least authorized. The timeout time may change over time.")
    public OffsetDateTime getAuthorizationTimeoutOn() {
        return this.authorizationTimeoutOn;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getAuthorizedOn() {
        return this.authorizedOn;
    }

    @ApiModelProperty(value="When auto confirmation is enabled the transaction can be confirmed by the user and does not require an explicit confirmation through the web service API.")
    public Boolean isAutoConfirmationEnabled() {
        return this.autoConfirmationEnabled;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @ApiModelProperty(value="When the charging of the customer fails we can retry the charging. This implies that we redirect the user back to the payment page which allows the customer to retry. By default we will retry.")
    public Boolean isChargeRetryEnabled() {
        return this.chargeRetryEnabled;
    }

    @ApiModelProperty(value="The completed amount is the total amount which has been captured so far.")
    public BigDecimal getCompletedAmount() {
        return this.completedAmount;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCompletedOn() {
        return this.completedOn;
    }

    @ApiModelProperty(value="The completion behavior controls when the transaction is completed.")
    public TransactionCompletionBehavior getCompletionBehavior() {
        return this.completionBehavior;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCompletionTimeoutOn() {
        return this.completionTimeoutOn;
    }

    @ApiModelProperty(value="")
    public Long getConfirmedBy() {
        return this.confirmedBy;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getConfirmedOn() {
        return this.confirmedOn;
    }

    @ApiModelProperty(value="")
    public Long getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(value="The created on date indicates the date on which the entity was stored into the database.")
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    @ApiModelProperty(value="")
    public String getCurrency() {
        return this.currency;
    }

    @ApiModelProperty(value="The customer email address is the email address of the customer. If no email address is provided on the shipping or billing address this address is used.")
    public String getCustomerEmailAddress() {
        return this.customerEmailAddress;
    }

    @ApiModelProperty(value="")
    public String getCustomerId() {
        return this.customerId;
    }

    @ApiModelProperty(value="The customer's presence indicates what kind of authentication method was finally used during authorization of the transaction. If no value is provided, 'Virtually Present' is used by default.")
    public CustomersPresence getCustomersPresence() {
        return this.customersPresence;
    }

    @ApiModelProperty(value="This date indicates when the decision has been made if a transaction should be delivered or not.")
    public OffsetDateTime getDeliveryDecisionMadeOn() {
        return this.deliveryDecisionMadeOn;
    }

    @ApiModelProperty(value="The device session identifier links the transaction with the session identifier provided in the URL of the device data JavaScript. This allows to link the transaction with the collected device data of the buyer.")
    public String getDeviceSessionIdentifier() {
        return this.deviceSessionIdentifier;
    }

    @ApiModelProperty(value="Flag indicating whether email sending is disabled for this particular transaction. Defaults to false.")
    public Boolean isEmailsDisabled() {
        return this.emailsDisabled;
    }

    @ApiModelProperty(value="The transaction's end of life indicates the date from which on no operation can be carried out anymore.")
    public OffsetDateTime getEndOfLife() {
        return this.endOfLife;
    }

    @ApiModelProperty(value="")
    public Environment getEnvironment() {
        return this.environment;
    }

    @ApiModelProperty(value="The environment selection strategy determines how the environment (test or production) for processing the transaction is selected.")
    public TransactionEnvironmentSelectionStrategy getEnvironmentSelectionStrategy() {
        return this.environmentSelectionStrategy;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getFailedOn() {
        return this.failedOn;
    }

    @ApiModelProperty(value="The user will be redirected to failed URL when the transaction could not be authorized or completed. In case no failed URL is specified a default failed page will be displayed.")
    public String getFailedUrl() {
        return this.failedUrl;
    }

    @ApiModelProperty(value="The failure reason describes why the transaction failed. This is only provided when the transaction is marked as failed.")
    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    @ApiModelProperty(value="")
    public TransactionGroup getGroup() {
        return this.group;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The Internet Protocol (IP) address identifies the device of the buyer.")
    public String getInternetProtocolAddress() {
        return this.internetProtocolAddress;
    }

    @ApiModelProperty(value="")
    public String getInternetProtocolAddressCountry() {
        return this.internetProtocolAddressCountry;
    }

    @ApiModelProperty(value="")
    public String getInvoiceMerchantReference() {
        return this.invoiceMerchantReference;
    }

    @ApiModelProperty(value="")
    public Boolean isJavaEnabled() {
        return this.javaEnabled;
    }

    @ApiModelProperty(value="")
    public String getLanguage() {
        return this.language;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @ApiModelProperty(value="Meta data allow to store additional data along the object.")
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    @ApiModelProperty(value="")
    public Long getParent() {
        return this.parent;
    }

    @ApiModelProperty(value="")
    public PaymentConnectorConfiguration getPaymentConnectorConfiguration() {
        return this.paymentConnectorConfiguration;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getProcessingOn() {
        return this.processingOn;
    }

    @ApiModelProperty(value="The refunded amount is the total amount which has been refunded so far.")
    public BigDecimal getRefundedAmount() {
        return this.refundedAmount;
    }

    @ApiModelProperty(value="")
    public String getScreenColorDepth() {
        return this.screenColorDepth;
    }

    @ApiModelProperty(value="")
    public String getScreenHeight() {
        return this.screenHeight;
    }

    @ApiModelProperty(value="")
    public String getScreenWidth() {
        return this.screenWidth;
    }

    @ApiModelProperty(value="")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @ApiModelProperty(value="")
    public String getShippingMethod() {
        return this.shippingMethod;
    }

    @ApiModelProperty(value="")
    public Long getSpaceViewId() {
        return this.spaceViewId;
    }

    @ApiModelProperty(value="")
    public TransactionState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The user will be redirected to success URL when the transaction could be authorized or completed. In case no success URL is specified a default success page will be displayed.")
    public String getSuccessUrl() {
        return this.successUrl;
    }

    @ApiModelProperty(value="The terminal on which the payment was processed.")
    public PaymentTerminal getTerminal() {
        return this.terminal;
    }

    @ApiModelProperty(value="The time zone defines in which time zone the customer is located in. The time zone may affects how dates are formatted when interacting with the customer.")
    public String getTimeZone() {
        return this.timeZone;
    }

    @ApiModelProperty(value="")
    public Token getToken() {
        return this.token;
    }

    @ApiModelProperty(value="The tokenization mode controls if and how the tokenization of payment information is applied to the transaction.")
    public TokenizationMode getTokenizationMode() {
        return this.tokenizationMode;
    }

    @ApiModelProperty(value="The total applied fees is the sum of all fees that have been applied so far.")
    public BigDecimal getTotalAppliedFees() {
        return this.totalAppliedFees;
    }

    @ApiModelProperty(value="The total settled amount is the total amount which has been settled so far.")
    public BigDecimal getTotalSettledAmount() {
        return this.totalSettledAmount;
    }

    @ApiModelProperty(value="The user agent header provides the exact string which contains the user agent of the buyer.")
    public String getUserAgentHeader() {
        return this.userAgentHeader;
    }

    @ApiModelProperty(value="The failure message describes for an end user why the transaction is failed in the language of the user. This is only provided when the transaction is marked as failed.")
    public String getUserFailureMessage() {
        return this.userFailureMessage;
    }

    @ApiModelProperty(value="The user interface type defines through which user interface the transaction has been processed resp. created.")
    public TransactionUserInterfaceType getUserInterfaceType() {
        return this.userInterfaceType;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(value="")
    public String getWindowHeight() {
        return this.windowHeight;
    }

    @ApiModelProperty(value="")
    public String getWindowWidth() {
        return this.windowWidth;
    }

    @ApiModelProperty(value="The number of years the transaction will be stored after it has been authorized.")
    public Integer getYearsToKeep() {
        return this.yearsToKeep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.acceptHeader, transaction.acceptHeader) && Objects.equals(this.acceptLanguageHeader, transaction.acceptLanguageHeader) && Objects.equals(this.allowedPaymentMethodBrands, transaction.allowedPaymentMethodBrands) && Objects.equals(this.allowedPaymentMethodConfigurations, transaction.allowedPaymentMethodConfigurations) && Objects.equals(this.authorizationAmount, transaction.authorizationAmount) && Objects.equals((Object)this.authorizationEnvironment, (Object)transaction.authorizationEnvironment) && Objects.equals(this.authorizationSalesChannel, transaction.authorizationSalesChannel) && Objects.equals(this.authorizationTimeoutOn, transaction.authorizationTimeoutOn) && Objects.equals(this.authorizedOn, transaction.authorizedOn) && Objects.equals(this.autoConfirmationEnabled, transaction.autoConfirmationEnabled) && Objects.equals(this.billingAddress, transaction.billingAddress) && Objects.equals(this.chargeRetryEnabled, transaction.chargeRetryEnabled) && Objects.equals(this.completedAmount, transaction.completedAmount) && Objects.equals(this.completedOn, transaction.completedOn) && Objects.equals((Object)this.completionBehavior, (Object)transaction.completionBehavior) && Objects.equals(this.completionTimeoutOn, transaction.completionTimeoutOn) && Objects.equals(this.confirmedBy, transaction.confirmedBy) && Objects.equals(this.confirmedOn, transaction.confirmedOn) && Objects.equals(this.createdBy, transaction.createdBy) && Objects.equals(this.createdOn, transaction.createdOn) && Objects.equals(this.currency, transaction.currency) && Objects.equals(this.customerEmailAddress, transaction.customerEmailAddress) && Objects.equals(this.customerId, transaction.customerId) && Objects.equals((Object)this.customersPresence, (Object)transaction.customersPresence) && Objects.equals(this.deliveryDecisionMadeOn, transaction.deliveryDecisionMadeOn) && Objects.equals(this.deviceSessionIdentifier, transaction.deviceSessionIdentifier) && Objects.equals(this.emailsDisabled, transaction.emailsDisabled) && Objects.equals(this.endOfLife, transaction.endOfLife) && Objects.equals((Object)this.environment, (Object)transaction.environment) && Objects.equals((Object)this.environmentSelectionStrategy, (Object)transaction.environmentSelectionStrategy) && Objects.equals(this.failedOn, transaction.failedOn) && Objects.equals(this.failedUrl, transaction.failedUrl) && Objects.equals(this.failureReason, transaction.failureReason) && Objects.equals(this.group, transaction.group) && Objects.equals(this.id, transaction.id) && Objects.equals(this.internetProtocolAddress, transaction.internetProtocolAddress) && Objects.equals(this.internetProtocolAddressCountry, transaction.internetProtocolAddressCountry) && Objects.equals(this.invoiceMerchantReference, transaction.invoiceMerchantReference) && Objects.equals(this.javaEnabled, transaction.javaEnabled) && Objects.equals(this.language, transaction.language) && Objects.equals(this.lineItems, transaction.lineItems) && Objects.equals(this.linkedSpaceId, transaction.linkedSpaceId) && Objects.equals(this.merchantReference, transaction.merchantReference) && Objects.equals(this.metaData, transaction.metaData) && Objects.equals(this.parent, transaction.parent) && Objects.equals(this.paymentConnectorConfiguration, transaction.paymentConnectorConfiguration) && Objects.equals(this.plannedPurgeDate, transaction.plannedPurgeDate) && Objects.equals(this.processingOn, transaction.processingOn) && Objects.equals(this.refundedAmount, transaction.refundedAmount) && Objects.equals(this.screenColorDepth, transaction.screenColorDepth) && Objects.equals(this.screenHeight, transaction.screenHeight) && Objects.equals(this.screenWidth, transaction.screenWidth) && Objects.equals(this.shippingAddress, transaction.shippingAddress) && Objects.equals(this.shippingMethod, transaction.shippingMethod) && Objects.equals(this.spaceViewId, transaction.spaceViewId) && Objects.equals((Object)this.state, (Object)transaction.state) && Objects.equals(this.successUrl, transaction.successUrl) && Objects.equals(this.terminal, transaction.terminal) && Objects.equals(this.timeZone, transaction.timeZone) && Objects.equals(this.token, transaction.token) && Objects.equals((Object)this.tokenizationMode, (Object)transaction.tokenizationMode) && Objects.equals(this.totalAppliedFees, transaction.totalAppliedFees) && Objects.equals(this.totalSettledAmount, transaction.totalSettledAmount) && Objects.equals(this.userAgentHeader, transaction.userAgentHeader) && Objects.equals(this.userFailureMessage, transaction.userFailureMessage) && Objects.equals((Object)this.userInterfaceType, (Object)transaction.userInterfaceType) && Objects.equals(this.version, transaction.version) && Objects.equals(this.windowHeight, transaction.windowHeight) && Objects.equals(this.windowWidth, transaction.windowWidth) && Objects.equals(this.yearsToKeep, transaction.yearsToKeep);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptHeader, this.acceptLanguageHeader, this.allowedPaymentMethodBrands, this.allowedPaymentMethodConfigurations, this.authorizationAmount, this.authorizationEnvironment, this.authorizationSalesChannel, this.authorizationTimeoutOn, this.authorizedOn, this.autoConfirmationEnabled, this.billingAddress, this.chargeRetryEnabled, this.completedAmount, this.completedOn, this.completionBehavior, this.completionTimeoutOn, this.confirmedBy, this.confirmedOn, this.createdBy, this.createdOn, this.currency, this.customerEmailAddress, this.customerId, this.customersPresence, this.deliveryDecisionMadeOn, this.deviceSessionIdentifier, this.emailsDisabled, this.endOfLife, this.environment, this.environmentSelectionStrategy, this.failedOn, this.failedUrl, this.failureReason, this.group, this.id, this.internetProtocolAddress, this.internetProtocolAddressCountry, this.invoiceMerchantReference, this.javaEnabled, this.language, this.lineItems, this.linkedSpaceId, this.merchantReference, this.metaData, this.parent, this.paymentConnectorConfiguration, this.plannedPurgeDate, this.processingOn, this.refundedAmount, this.screenColorDepth, this.screenHeight, this.screenWidth, this.shippingAddress, this.shippingMethod, this.spaceViewId, this.state, this.successUrl, this.terminal, this.timeZone, this.token, this.tokenizationMode, this.totalAppliedFees, this.totalSettledAmount, this.userAgentHeader, this.userFailureMessage, this.userInterfaceType, this.version, this.windowHeight, this.windowWidth, this.yearsToKeep});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    acceptHeader: ").append(this.toIndentedString(this.acceptHeader)).append("\n");
        sb.append("    acceptLanguageHeader: ").append(this.toIndentedString(this.acceptLanguageHeader)).append("\n");
        sb.append("    allowedPaymentMethodBrands: ").append(this.toIndentedString(this.allowedPaymentMethodBrands)).append("\n");
        sb.append("    allowedPaymentMethodConfigurations: ").append(this.toIndentedString(this.allowedPaymentMethodConfigurations)).append("\n");
        sb.append("    authorizationAmount: ").append(this.toIndentedString(this.authorizationAmount)).append("\n");
        sb.append("    authorizationEnvironment: ").append(this.toIndentedString((Object)this.authorizationEnvironment)).append("\n");
        sb.append("    authorizationSalesChannel: ").append(this.toIndentedString(this.authorizationSalesChannel)).append("\n");
        sb.append("    authorizationTimeoutOn: ").append(this.toIndentedString(this.authorizationTimeoutOn)).append("\n");
        sb.append("    authorizedOn: ").append(this.toIndentedString(this.authorizedOn)).append("\n");
        sb.append("    autoConfirmationEnabled: ").append(this.toIndentedString(this.autoConfirmationEnabled)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    chargeRetryEnabled: ").append(this.toIndentedString(this.chargeRetryEnabled)).append("\n");
        sb.append("    completedAmount: ").append(this.toIndentedString(this.completedAmount)).append("\n");
        sb.append("    completedOn: ").append(this.toIndentedString(this.completedOn)).append("\n");
        sb.append("    completionBehavior: ").append(this.toIndentedString((Object)this.completionBehavior)).append("\n");
        sb.append("    completionTimeoutOn: ").append(this.toIndentedString(this.completionTimeoutOn)).append("\n");
        sb.append("    confirmedBy: ").append(this.toIndentedString(this.confirmedBy)).append("\n");
        sb.append("    confirmedOn: ").append(this.toIndentedString(this.confirmedOn)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    customerEmailAddress: ").append(this.toIndentedString(this.customerEmailAddress)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    customersPresence: ").append(this.toIndentedString((Object)this.customersPresence)).append("\n");
        sb.append("    deliveryDecisionMadeOn: ").append(this.toIndentedString(this.deliveryDecisionMadeOn)).append("\n");
        sb.append("    deviceSessionIdentifier: ").append(this.toIndentedString(this.deviceSessionIdentifier)).append("\n");
        sb.append("    emailsDisabled: ").append(this.toIndentedString(this.emailsDisabled)).append("\n");
        sb.append("    endOfLife: ").append(this.toIndentedString(this.endOfLife)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("    environmentSelectionStrategy: ").append(this.toIndentedString((Object)this.environmentSelectionStrategy)).append("\n");
        sb.append("    failedOn: ").append(this.toIndentedString(this.failedOn)).append("\n");
        sb.append("    failedUrl: ").append(this.toIndentedString(this.failedUrl)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    internetProtocolAddress: ").append(this.toIndentedString(this.internetProtocolAddress)).append("\n");
        sb.append("    internetProtocolAddressCountry: ").append(this.toIndentedString(this.internetProtocolAddressCountry)).append("\n");
        sb.append("    invoiceMerchantReference: ").append(this.toIndentedString(this.invoiceMerchantReference)).append("\n");
        sb.append("    javaEnabled: ").append(this.toIndentedString(this.javaEnabled)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    metaData: ").append(this.toIndentedString(this.metaData)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    paymentConnectorConfiguration: ").append(this.toIndentedString(this.paymentConnectorConfiguration)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    processingOn: ").append(this.toIndentedString(this.processingOn)).append("\n");
        sb.append("    refundedAmount: ").append(this.toIndentedString(this.refundedAmount)).append("\n");
        sb.append("    screenColorDepth: ").append(this.toIndentedString(this.screenColorDepth)).append("\n");
        sb.append("    screenHeight: ").append(this.toIndentedString(this.screenHeight)).append("\n");
        sb.append("    screenWidth: ").append(this.toIndentedString(this.screenWidth)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    shippingMethod: ").append(this.toIndentedString(this.shippingMethod)).append("\n");
        sb.append("    spaceViewId: ").append(this.toIndentedString(this.spaceViewId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    successUrl: ").append(this.toIndentedString(this.successUrl)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenizationMode: ").append(this.toIndentedString((Object)this.tokenizationMode)).append("\n");
        sb.append("    totalAppliedFees: ").append(this.toIndentedString(this.totalAppliedFees)).append("\n");
        sb.append("    totalSettledAmount: ").append(this.toIndentedString(this.totalSettledAmount)).append("\n");
        sb.append("    userAgentHeader: ").append(this.toIndentedString(this.userAgentHeader)).append("\n");
        sb.append("    userFailureMessage: ").append(this.toIndentedString(this.userFailureMessage)).append("\n");
        sb.append("    userInterfaceType: ").append(this.toIndentedString((Object)this.userInterfaceType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    windowHeight: ").append(this.toIndentedString(this.windowHeight)).append("\n");
        sb.append("    windowWidth: ").append(this.toIndentedString(this.windowWidth)).append("\n");
        sb.append("    yearsToKeep: ").append(this.toIndentedString(this.yearsToKeep)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

