/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.Account;
import ch.postfinance.sdk.model.DatabaseTranslatedString;
import ch.postfinance.sdk.model.Permission;
import ch.postfinance.sdk.model.RoleState;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@ApiModel(description="")
public class Role {
    @JsonProperty(value="account")
    protected Account account = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="name")
    protected DatabaseTranslatedString name = null;
    @JsonProperty(value="permissions")
    protected List<Permission> permissions = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="state")
    protected RoleState state = null;
    @JsonProperty(value="twoFactorRequired")
    protected Boolean twoFactorRequired = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The account to which this role belongs to. This role can only be assigned within the assigned account and the sub accounts of the assigned account.")
    public Account getAccount() {
        return this.account;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The name of this role is used to identify the role within administrative interfaces.")
    public DatabaseTranslatedString getName() {
        return this.name;
    }

    @ApiModelProperty(value="Set of permissions that are granted to this role.")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="")
    public RoleState getState() {
        return this.state;
    }

    @ApiModelProperty(value="Defines whether having been granted this role will force a user to use two-factor authentication.")
    public Boolean isTwoFactorRequired() {
        return this.twoFactorRequired;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.account, role.account) && Objects.equals(this.id, role.id) && Objects.equals(this.name, role.name) && Objects.equals(this.permissions, role.permissions) && Objects.equals(this.plannedPurgeDate, role.plannedPurgeDate) && Objects.equals((Object)this.state, (Object)role.state) && Objects.equals(this.twoFactorRequired, role.twoFactorRequired) && Objects.equals(this.version, role.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.id, this.name, this.permissions, this.plannedPurgeDate, this.state, this.twoFactorRequired, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Role {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    twoFactorRequired: ").append(this.toIndentedString(this.twoFactorRequired)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

