/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.CreationEntityState;
import ch.postfinance.sdk.model.DataCollectionType;
import ch.postfinance.sdk.model.DatabaseTranslatedString;
import ch.postfinance.sdk.model.OneClickPaymentMode;
import ch.postfinance.sdk.model.ResourcePath;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="The payment method configuration builds the base to connect with different payment method connectors.")
public class PaymentMethodConfiguration {
    @JsonProperty(value="dataCollectionType")
    protected DataCollectionType dataCollectionType = null;
    @JsonProperty(value="description")
    protected DatabaseTranslatedString description = null;
    @JsonProperty(value="id")
    protected Long id = null;
    @JsonProperty(value="imageResourcePath")
    protected ResourcePath imageResourcePath = null;
    @JsonProperty(value="linkedSpaceId")
    protected Long linkedSpaceId = null;
    @JsonProperty(value="name")
    protected String name = null;
    @JsonProperty(value="oneClickPaymentMode")
    protected OneClickPaymentMode oneClickPaymentMode = null;
    @JsonProperty(value="paymentMethod")
    protected Long paymentMethod = null;
    @JsonProperty(value="plannedPurgeDate")
    protected OffsetDateTime plannedPurgeDate = null;
    @JsonProperty(value="resolvedDescription")
    protected Map<String, String> resolvedDescription = null;
    @JsonProperty(value="resolvedImageUrl")
    protected String resolvedImageUrl = null;
    @JsonProperty(value="resolvedTitle")
    protected Map<String, String> resolvedTitle = null;
    @JsonProperty(value="sortOrder")
    protected Integer sortOrder = null;
    @JsonProperty(value="spaceId")
    protected Long spaceId = null;
    @JsonProperty(value="state")
    protected CreationEntityState state = null;
    @JsonProperty(value="title")
    protected DatabaseTranslatedString title = null;
    @JsonProperty(value="version")
    protected Integer version = null;

    @ApiModelProperty(value="The data collection type determines who is collecting the payment information. This can be done either by the processor (offsite) or by our application (onsite).")
    public DataCollectionType getDataCollectionType() {
        return this.dataCollectionType;
    }

    @ApiModelProperty(value="The payment method configuration description can be used to show a text during the payment process. Choose an appropriate description as it will be displayed to your customer.")
    public DatabaseTranslatedString getDescription() {
        return this.description;
    }

    @ApiModelProperty(value="The ID is the primary key of the entity. The ID identifies the entity uniquely.")
    public Long getId() {
        return this.id;
    }

    @ApiModelProperty(value="The image of the payment method configuration overrides the default image of the payment method.")
    public ResourcePath getImageResourcePath() {
        return this.imageResourcePath;
    }

    @ApiModelProperty(value="The linked space id holds the ID of the space to which the entity belongs to.")
    public Long getLinkedSpaceId() {
        return this.linkedSpaceId;
    }

    @ApiModelProperty(value="The payment method configuration name is used internally to identify the payment method configuration. For example the name is used within search fields and hence it should be distinct and descriptive.")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="When the buyer is present on the payment page or within the iFrame the payment details can be stored automatically. The buyer will be able to use the stored payment details for subsequent transactions. When the transaction already contains a token one-click payments are disabled anyway")
    public OneClickPaymentMode getOneClickPaymentMode() {
        return this.oneClickPaymentMode;
    }

    @ApiModelProperty(value="")
    public Long getPaymentMethod() {
        return this.paymentMethod;
    }

    @ApiModelProperty(value="The planned purge date indicates when the entity is permanently removed. When the date is null the entity is not planned to be removed.")
    public OffsetDateTime getPlannedPurgeDate() {
        return this.plannedPurgeDate;
    }

    @ApiModelProperty(value="The resolved description uses the specified description or the default one when it is not overridden.")
    public Map<String, String> getResolvedDescription() {
        return this.resolvedDescription;
    }

    @ApiModelProperty(value="The resolved URL of the image to use with this payment method.")
    public String getResolvedImageUrl() {
        return this.resolvedImageUrl;
    }

    @ApiModelProperty(value="The resolved title uses the specified title or the default one when it is not overridden.")
    public Map<String, String> getResolvedTitle() {
        return this.resolvedTitle;
    }

    @ApiModelProperty(value="The sort order of the payment method determines the ordering of the methods shown to the user during the payment process.")
    public Integer getSortOrder() {
        return this.sortOrder;
    }

    @ApiModelProperty(value="")
    public Long getSpaceId() {
        return this.spaceId;
    }

    @ApiModelProperty(value="")
    public CreationEntityState getState() {
        return this.state;
    }

    @ApiModelProperty(value="The title of the payment method configuration is used within the payment process. The title is visible to the customer.")
    public DatabaseTranslatedString getTitle() {
        return this.title;
    }

    @ApiModelProperty(value="The version number indicates the version of the entity. The version is incremented whenever the entity is changed.")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodConfiguration paymentMethodConfiguration = (PaymentMethodConfiguration)o;
        return Objects.equals((Object)this.dataCollectionType, (Object)paymentMethodConfiguration.dataCollectionType) && Objects.equals(this.description, paymentMethodConfiguration.description) && Objects.equals(this.id, paymentMethodConfiguration.id) && Objects.equals(this.imageResourcePath, paymentMethodConfiguration.imageResourcePath) && Objects.equals(this.linkedSpaceId, paymentMethodConfiguration.linkedSpaceId) && Objects.equals(this.name, paymentMethodConfiguration.name) && Objects.equals((Object)this.oneClickPaymentMode, (Object)paymentMethodConfiguration.oneClickPaymentMode) && Objects.equals(this.paymentMethod, paymentMethodConfiguration.paymentMethod) && Objects.equals(this.plannedPurgeDate, paymentMethodConfiguration.plannedPurgeDate) && Objects.equals(this.resolvedDescription, paymentMethodConfiguration.resolvedDescription) && Objects.equals(this.resolvedImageUrl, paymentMethodConfiguration.resolvedImageUrl) && Objects.equals(this.resolvedTitle, paymentMethodConfiguration.resolvedTitle) && Objects.equals(this.sortOrder, paymentMethodConfiguration.sortOrder) && Objects.equals(this.spaceId, paymentMethodConfiguration.spaceId) && Objects.equals((Object)this.state, (Object)paymentMethodConfiguration.state) && Objects.equals(this.title, paymentMethodConfiguration.title) && Objects.equals(this.version, paymentMethodConfiguration.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataCollectionType, this.description, this.id, this.imageResourcePath, this.linkedSpaceId, this.name, this.oneClickPaymentMode, this.paymentMethod, this.plannedPurgeDate, this.resolvedDescription, this.resolvedImageUrl, this.resolvedTitle, this.sortOrder, this.spaceId, this.state, this.title, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodConfiguration {\n");
        sb.append("    dataCollectionType: ").append(this.toIndentedString((Object)this.dataCollectionType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    imageResourcePath: ").append(this.toIndentedString(this.imageResourcePath)).append("\n");
        sb.append("    linkedSpaceId: ").append(this.toIndentedString(this.linkedSpaceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    oneClickPaymentMode: ").append(this.toIndentedString((Object)this.oneClickPaymentMode)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    plannedPurgeDate: ").append(this.toIndentedString(this.plannedPurgeDate)).append("\n");
        sb.append("    resolvedDescription: ").append(this.toIndentedString(this.resolvedDescription)).append("\n");
        sb.append("    resolvedImageUrl: ").append(this.toIndentedString(this.resolvedImageUrl)).append("\n");
        sb.append("    resolvedTitle: ").append(this.toIndentedString(this.resolvedTitle)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString(this.sortOrder)).append("\n");
        sb.append("    spaceId: ").append(this.toIndentedString(this.spaceId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

