/*
 * Decompiled with CFR 0.152.
 */
package ch.postfinance.sdk.model;

import ch.postfinance.sdk.model.EntityQuery;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The entity property export request contains the information required to create an export of a list of entities.")
public class EntityExportRequest {
    @JsonProperty(value="properties")
    protected List<String> properties = new ArrayList<String>();
    @JsonProperty(value="query")
    protected EntityQuery query = null;

    public EntityExportRequest properties(List<String> properties) {
        this.properties = properties;
        return this;
    }

    public EntityExportRequest addPropertiesItem(String propertiesItem) {
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The properties is a list of property paths which should be exported.")
    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public EntityExportRequest query(EntityQuery query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="The query limits the returned entries. The query allows to restrict the entries to return and it allows to control the order of them.")
    public EntityQuery getQuery() {
        return this.query;
    }

    public void setQuery(EntityQuery query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityExportRequest entityExportRequest = (EntityExportRequest)o;
        return Objects.equals(this.properties, entityExportRequest.properties) && Objects.equals(this.query, entityExportRequest.query);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.query);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityExportRequest {\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

